/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jbpm.eventmessaging.EventKey;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.Attachment;
import org.jbpm.task.Comment;
import org.jbpm.task.Content;
import org.jbpm.task.OrganizationalEntity;
import org.jbpm.task.Status;
import org.jbpm.task.Task;
import org.jbpm.task.service.BaseHandler;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.CommandName;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.FaultData;
import org.jbpm.task.service.Operation;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;
import org.jbpm.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;

public class TaskClient
implements AsyncTaskService {
    private final BaseHandler handler;
    private final AtomicInteger counter;
    private final String name;
    private final TaskClientConnector connector;
    private final Environment environment;

    public TaskClient(TaskClientConnector connector) {
        this(connector, null);
    }

    public TaskClient(TaskClientConnector connector, Environment environment) {
        this.connector = connector;
        this.counter = connector.getCounter();
        this.name = connector.getName();
        this.handler = connector.getHandler();
        this.environment = environment;
    }

    @Override
    public void addTask(Task task, ContentData content, TaskClientHandler.AddTaskResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(task);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddTaskRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTask(long taskId, TaskClientHandler.GetTaskResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(taskId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetTaskRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void addComment(long taskId, Comment comment, TaskClientHandler.AddCommentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(comment);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddCommentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void deleteComment(long taskId, long commentId, TaskClientHandler.DeleteCommentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(commentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteCommentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void addAttachment(long taskId, Attachment attachment, Content content, TaskClientHandler.AddAttachmentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(attachment);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.AddAttachmentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void deleteAttachment(long taskId, long attachmentId, long contentId, TaskClientHandler.DeleteAttachmentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(attachmentId);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteAttachmentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void setDocumentContent(long taskId, Content content, TaskClientHandler.SetDocumentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(content);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetDocumentContentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getContent(long contentId, TaskClientHandler.GetContentResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(contentId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.GetContentRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void claim(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Claim);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    @Deprecated
    public void claim(long taskId, String userId, List<String> groupIds, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(6);
        args.add((Object)Operation.Claim);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(null);
        args.add(groupIds);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void start(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Start);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void stop(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Stop);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void release(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Release);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void suspend(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Suspend);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void resume(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Resume);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void skip(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Skip);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void delegate(long taskId, String userId, String targetUserId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add((Object)Operation.Delegate);
        args.add(taskId);
        args.add(userId);
        args.add(targetUserId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void forward(long taskId, String userId, String targetEntityId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add((Object)Operation.Forward);
        args.add(taskId);
        args.add(userId);
        args.add(targetEntityId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void complete(long taskId, String userId, ContentData outputData, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add((Object)Operation.Complete);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(outputData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void completeWithResults(long taskId, String userId, Object results, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ContentData outputData = ContentMarshallerHelper.marshal(results, this.environment);
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add((Object)Operation.Complete);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(outputData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void fail(long taskId, String userId, FaultData faultData, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add((Object)Operation.Fail);
        args.add(taskId);
        args.add(userId);
        args.add(null);
        args.add(faultData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksOwned(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksOwned, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksOwned(String userId, List<Status> status, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(userId);
        args.add(status);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksOwnedWithParticularStatus, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTaskByWorkItemId(long workItemId, TaskClientHandler.GetTaskResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(workItemId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTaskByWorkItemId, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksByProcessInstanceId(long processInstanceId, TaskClientHandler.GetIdsResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(processInstanceId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksByProcessInstanceId, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsBusinessAdministrator(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsBusinessAdministrator, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsExcludedOwner(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsExcludedOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsPotentialOwner(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    @Deprecated
    public void getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        this.getTasksAssignedAsPotentialOwner(userId, groupIds, language, -1, -1, responseHandler);
    }

    @Override
    @Deprecated
    public void getTasksAssignedAsPotentialOwner(String userId, List<String> groupIds, String language, int firstResult, int maxResult, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add(userId);
        args.add(groupIds);
        args.add(language);
        args.add(firstResult);
        args.add(maxResult);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwnerWithGroup, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getSubTasksAssignedAsPotentialOwner(long parentId, String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QuerySubTasksAssignedAsPotentialOwner, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getSubTasksByParent(long parentId, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(parentId);
        args.add("en-UK");
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryGetSubTasksByParentTaskId, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsRecipient(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsRecipient, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsTaskInitiator(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskInitiator, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsTaskStakeholder(String userId, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsTaskStakeholder, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void registerForEvent(EventKey key, boolean remove, EventResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(key);
        args.add(remove);
        args.add(this.name);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.RegisterForEventRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void unregisterForEvent(EventKey key) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(key);
        args.add(this.name);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.UnRegisterForEventRequest, args);
        this.connector.write(cmd);
    }

    @Override
    @Deprecated
    public void query(String qlString, Integer size, Integer offset, TaskClientHandler.QueryGenericResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(qlString);
        args.add(size);
        args.add(offset);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryGenericRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void register(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Register);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void remove(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Remove);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void nominate(long taskId, String userId, List<OrganizationalEntity> potentialOwners, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(userId);
        args.add(potentialOwners);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.NominateTaskRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void activate(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Activate);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void exit(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add((Object)Operation.Exit);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.OperationRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void setOutput(long taskId, String userId, ContentData outputContentData, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(userId);
        args.add(outputContentData);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetOutputRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void deleteOutput(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteOutputRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void setFault(long taskId, String userId, FaultData fault, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(userId);
        args.add(fault);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetFaultRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void deleteFault(long taskId, String userId, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(taskId);
        args.add(userId);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.DeleteFaultRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void setPriority(long taskId, String userId, int priority, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(taskId);
        args.add(userId);
        args.add(priority);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.SetPriorityRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public boolean connect() {
        return this.connector.connect();
    }

    @Override
    public boolean connect(String address, int port) {
        return this.connector.connect(address, port);
    }

    @Override
    public void disconnect() throws Exception {
        this.connector.disconnect();
    }

    @Override
    public void claimNextAvailable(String userId, String language, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.ClaimNextAvailableRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    @Deprecated
    public void claimNextAvailable(String userId, List<String> groupIds, String language, TaskClientHandler.TaskOperationResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(userId);
        args.add(groupIds);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.ClaimNextAvailableRequest, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksAssignedAsPotentialOwnerByStatus(String userId, List<Status> status, String language, BlockingTaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(status);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwnerByStatus, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    @Deprecated
    public void getTasksAssignedAsPotentialOwnerByStatusByGroup(String userId, List<String> groupIds, List<Status> status, String language, BlockingTaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(userId);
        args.add(groupIds);
        args.add(status);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksAssignedAsPotentialOwnerByStatusByGroup, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksByStatusByProcessId(long processInstanceId, List<Status> status, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(processInstanceId);
        args.add(status);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksByStatusByProcessId, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }

    @Override
    public void getTasksByStatusByProcessIdByTaskName(long processInstanceId, List<Status> status, String taskName, String language, TaskClientHandler.TaskSummaryResponseHandler responseHandler) {
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(processInstanceId);
        args.add(status);
        args.add(taskName);
        args.add(language);
        Command cmd = new Command(this.counter.getAndIncrement(), CommandName.QueryTasksByStatusByProcessIdByTaskName, args);
        this.handler.addResponseHandler(cmd.getId(), responseHandler);
        this.connector.write(cmd);
    }
}

