/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.task.service;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jbpm.eventmessaging.EventResponseHandler;
import org.jbpm.eventmessaging.Payload;
import org.jbpm.task.Content;
import org.jbpm.task.Task;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.Command;
import org.jbpm.task.service.SessionWriter;
import org.jbpm.task.service.TaskClient;
import org.kie.internal.SystemEventListener;
import org.kie.internal.task.service.ResponseHandler;

public class TaskClientHandler {
    private TaskClient client;
    private SystemEventListener systemEventListener;
    private final Map<Integer, ResponseHandler> responseHandlers;

    public TaskClientHandler(Map<Integer, ResponseHandler> responseHandlers, SystemEventListener systemEventListener) {
        this.responseHandlers = responseHandlers;
        this.systemEventListener = systemEventListener;
    }

    public TaskClient getClient() {
        return this.client;
    }

    public void setClient(TaskClient client) {
        this.client = client;
    }

    public void exceptionCaught(SessionWriter session, Throwable cause) throws Exception {
        this.systemEventListener.exception("Uncaught exception on client", cause);
    }

    public void messageReceived(SessionWriter session, Object message) throws Exception {
        Command cmd = (Command)message;
        this.systemEventListener.debug("Message receieved on client : " + (Object)((Object)cmd.getName()));
        this.systemEventListener.debug("Arguments : " + Arrays.toString(cmd.getArguments().toArray()));
        switch (cmd.getName()) {
            case OperationResponse: {
                TaskOperationResponseHandler responseHandler = (TaskOperationResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case GetTaskResponse: {
                GetTaskResponseHandler responseHandler = (GetTaskResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Task task = (Task)cmd.getArguments().get(0);
                responseHandler.execute(task);
                break;
            }
            case AddTaskResponse: {
                AddTaskResponseHandler responseHandler = (AddTaskResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long taskId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(taskId);
                break;
            }
            case AddCommentResponse: {
                AddCommentResponseHandler responseHandler = (AddCommentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long commentId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(commentId);
                break;
            }
            case DeleteCommentResponse: {
                DeleteCommentResponseHandler responseHandler = (DeleteCommentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case AddAttachmentResponse: {
                AddAttachmentResponseHandler responseHandler = (AddAttachmentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long attachmentId = (Long)cmd.getArguments().get(0);
                long contentId = (Long)cmd.getArguments().get(1);
                responseHandler.execute(attachmentId, contentId);
                break;
            }
            case DeleteAttachmentResponse: {
                DeleteAttachmentResponseHandler responseHandler = (DeleteAttachmentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                responseHandler.setIsDone(true);
                break;
            }
            case GetContentResponse: {
                GetContentResponseHandler responseHandler = (GetContentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Content content = (Content)cmd.getArguments().get(0);
                responseHandler.execute(content);
                break;
            }
            case SetDocumentContentResponse: {
                SetDocumentResponseHandler responseHandler = (SetDocumentResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                long contentId = (Long)cmd.getArguments().get(0);
                responseHandler.execute(contentId);
                break;
            }
            case QueryTaskSummaryResponse: {
                TaskSummaryResponseHandler responseHandler = (TaskSummaryResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                List results = (List)cmd.getArguments().get(0);
                responseHandler.execute(results);
                break;
            }
            case QueryTaskByWorkItemIdResponse: {
                GetTaskResponseHandler responseHandler = (GetTaskResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Task result = (Task)cmd.getArguments().get(0);
                responseHandler.execute(result);
                break;
            }
            case QueryTasksByProcessInstanceIdResponse: {
                GetIdsResponseHandler responseHandler = (GetIdsResponseHandler)this.responseHandlers.remove(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                List result = (List)cmd.getArguments().get(0);
                responseHandler.execute(result);
                break;
            }
            case EventTriggerResponse: {
                EventResponseHandler responseHandler = (EventResponseHandler)this.responseHandlers.get(cmd.getId());
                if (responseHandler == null) break;
                if (responseHandler.isRemove()) {
                    this.responseHandlers.remove(cmd.getId());
                }
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                Payload payload = (Payload)cmd.getArguments().get(0);
                responseHandler.execute(payload);
                break;
            }
            case QueryGenericResponse: {
                QueryGenericResponseHandler responseHandler = (QueryGenericResponseHandler)this.responseHandlers.get(cmd.getId());
                if (responseHandler == null) break;
                if (!cmd.getArguments().isEmpty() && cmd.getArguments().get(0) instanceof RuntimeException) {
                    responseHandler.setError((RuntimeException)cmd.getArguments().get(0));
                    break;
                }
                List results = (List)cmd.getArguments().get(0);
                responseHandler.execute(results);
                break;
            }
        }
    }

    public static interface QueryGenericResponseHandler
    extends ResponseHandler {
        public void execute(List<?> var1);
    }

    public static interface TaskSummaryResponseHandler
    extends ResponseHandler {
        public void execute(List<TaskSummary> var1);
    }

    public static interface GetContentResponseHandler
    extends ResponseHandler {
        public void execute(Content var1);
    }

    public static interface SetDocumentResponseHandler
    extends ResponseHandler {
        public void execute(long var1);
    }

    public static interface DeleteAttachmentResponseHandler
    extends ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddAttachmentResponseHandler
    extends ResponseHandler {
        public void execute(long var1, long var3);
    }

    public static interface DeleteCommentResponseHandler
    extends ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddCommentResponseHandler
    extends ResponseHandler {
        public void execute(long var1);
    }

    public static interface TaskOperationResponseHandler
    extends ResponseHandler {
        public void setIsDone(boolean var1);
    }

    public static interface AddTaskResponseHandler
    extends ResponseHandler {
        public void execute(long var1);
    }

    public static interface GetIdsResponseHandler
    extends ResponseHandler {
        public void execute(List<Long> var1);
    }

    public static interface GetTaskResponseHandler
    extends ResponseHandler {
        public void execute(Task var1);
    }
}

