/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.file;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kie.commons.java.nio.file.FileStore;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.java.nio.fs.file.BaseSimpleFileSystem;
import org.kie.commons.java.nio.fs.file.SimpleWindowsFileStore;

public class SimpleWindowsFileSystem
extends BaseSimpleFileSystem {
    SimpleWindowsFileSystem(FileSystemProvider provider, String path) {
        super(provider, path);
    }

    SimpleWindowsFileSystem(File[] roots, FileSystemProvider provider, String path) {
        super(roots, provider, path);
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    public Iterable<Path> getRootDirectories() {
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return new Iterator<Path>(){
                    int i = -1;

                    @Override
                    public boolean hasNext() {
                        return this.i + 1 < SimpleWindowsFileSystem.this.listRoots().length;
                    }

                    @Override
                    public Path next() {
                        ++this.i;
                        if (this.i >= SimpleWindowsFileSystem.this.listRoots().length) {
                            throw new NoSuchElementException();
                        }
                        return SimpleWindowsFileSystem.this.getPath(SimpleWindowsFileSystem.this.listRoots()[this.i].toString(), new String[0]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<FileStore> getFileStores() {
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new Iterator<FileStore>(){
                    int i = -1;

                    @Override
                    public boolean hasNext() {
                        return this.i + 1 < SimpleWindowsFileSystem.this.listRoots().length;
                    }

                    @Override
                    public FileStore next() {
                        ++this.i;
                        if (this.i >= SimpleWindowsFileSystem.this.listRoots().length) {
                            throw new NoSuchElementException();
                        }
                        return new SimpleWindowsFileStore(SimpleWindowsFileSystem.this.listRoots(), SimpleWindowsFileSystem.this, SimpleWindowsFileSystem.this.listRoots()[this.i].toString());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

