/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.utils.Uid;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXAResourceHolder
extends AbstractXAStatefulHolder
implements XAResourceHolder {
    private static final Logger log = LoggerFactory.getLogger(AbstractXAResourceHolder.class);
    private final Map xaResourceHolderStates = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getXAResourceHolderStatesForGtrid(Uid gtrid) {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            return (Map)this.xaResourceHolderStates.get(gtrid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXAResourceHolderState(BitronixXid xid, XAResourceHolderState xaResourceHolderState) {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            if (log.isDebugEnabled()) {
                log.debug("putting XAResourceHolderState [" + xaResourceHolderState + "] on " + this);
            }
            Uid gtrid = xid.getGlobalTransactionIdUid();
            Uid bqual = xid.getBranchQualifierUid();
            if (!this.xaResourceHolderStates.containsKey(gtrid)) {
                if (log.isDebugEnabled()) {
                    log.debug("GTRID [" + gtrid + "] previously unknown to " + this + ", adding it to the resource's transactions list");
                }
                LinkedHashMap<Uid, XAResourceHolderState> statesForGtrid = new LinkedHashMap<Uid, XAResourceHolderState>(4);
                statesForGtrid.put(bqual, xaResourceHolderState);
                this.xaResourceHolderStates.put(gtrid, statesForGtrid);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("GTRID [" + gtrid + "] previously known to " + this + ", adding it to the resource's transactions list");
                }
                Map statesForGtrid = (Map)this.xaResourceHolderStates.get(gtrid);
                statesForGtrid.put(bqual, xaResourceHolderState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceHolderState(BitronixXid xid) {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            if (log.isDebugEnabled()) {
                log.debug("removing XAResourceHolderState of xid " + xid + " from " + this);
            }
            Uid gtrid = xid.getGlobalTransactionIdUid();
            Uid bqual = xid.getBranchQualifierUid();
            Map statesForGtrid = (Map)this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid == null) {
                log.warn("tried to remove unknown GTRID [" + gtrid + "] from " + this + " - Bug?");
                return;
            }
            Object removed = statesForGtrid.remove(bqual);
            if (removed == null) {
                log.warn("tried to remove unknown BQUAL [" + bqual + "] from " + this + " - Bug?");
                return;
            }
            if (statesForGtrid.isEmpty()) {
                this.xaResourceHolderStates.remove(gtrid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStateForXAResource(XAResourceHolder xaResourceHolder) {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            for (Map statesForGtrid : this.xaResourceHolderStates.values()) {
                for (XAResourceHolderState otherXaResourceHolderState : statesForGtrid.values()) {
                    if (otherXaResourceHolderState.getXAResource() != xaResourceHolder.getXAResource()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("resource " + xaResourceHolder + " is enlisted in another transaction with " + otherXaResourceHolderState.getXid().toString());
                    }
                    return true;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("resource not enlisted in any transaction: " + xaResourceHolder);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParticipatingInActiveGlobalTransaction() {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            Uid gtrid;
            BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
            Uid uid = gtrid = currentTransaction == null ? null : currentTransaction.getResourceManager().getGtrid();
            if (gtrid == null) {
                return false;
            }
            Map statesForGtrid = (Map)this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid == null) {
                return false;
            }
            for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                if (xaResourceHolderState == null || !xaResourceHolderState.isStarted() || xaResourceHolderState.isSuspended() || xaResourceHolderState.isEnded()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getXAResourceHolderStateGtrids() {
        Map map = this.xaResourceHolderStates;
        synchronized (map) {
            HashSet<String> gtridsAsStrings = new HashSet<String>();
            for (Uid uid : this.xaResourceHolderStates.keySet()) {
                gtridsAsStrings.add(uid.toString());
            }
            return gtridsAsStrings;
        }
    }
}

