/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.entities;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.executor.entities.RequestInfo;

@Entity
@SequenceGenerator(name="errorInfoIdSeq", sequenceName="ERROR_INFO_ID_SEQ")
public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = 1548071325967795108L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="errorInfoIdSeq")
    private Long id;
    @Column(name="timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date time;
    private String message;
    @Column(length=5000)
    private String stacktrace;
    @ManyToOne
    @JoinColumn(name="REQUEST_ID", nullable=false)
    private RequestInfo requestInfo;

    public ErrorInfo() {
    }

    public ErrorInfo(String message, String stacktrace) {
        this.message = message;
        this.stacktrace = stacktrace;
        this.time = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public void setStacktrace(String stacktrace) {
        this.stacktrace = stacktrace;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public String toString() {
        return "ErrorInfo{id=" + this.id + ", time=" + this.time + ", message=" + this.message + ", stacktrace=" + this.stacktrace + ", requestInfo=" + this.requestInfo.getId() + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)obj;
        if (!(this.id == other.id || this.id != null && this.id.equals(other.id))) {
            return false;
        }
        if (!(this.time == other.time || this.time != null && this.time.equals(other.time))) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.stacktrace == null ? other.stacktrace != null : !this.stacktrace.equals(other.stacktrace)) {
            return false;
        }
        return this.requestInfo == other.requestInfo || this.requestInfo != null && this.requestInfo.equals(other.requestInfo);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 37 * hash + (this.time != null ? this.time.hashCode() : 0);
        hash = 37 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 37 * hash + (this.stacktrace != null ? this.stacktrace.hashCode() : 0);
        hash = 37 * hash + (this.requestInfo != null ? this.requestInfo.hashCode() : 0);
        return hash;
    }
}

