/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.wagon;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.util.DateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CountDownLatch;
import org.sonatype.maven.wagon.PipedErrorInputStream;

class GetExchange {
    private final AsyncHttpClient httpClient;
    private final CountDownLatch latch;
    private int statusCode;
    private long contentLength = -1L;
    private long lastModified;
    private PipedErrorInputStream inputStream;
    private PipedOutputStream outputStream;
    private Throwable error;

    public GetExchange(AsyncHttpClient httpClient) throws IOException {
        this.httpClient = httpClient;
        this.latch = new CountDownLatch(1);
        this.inputStream = new PipedErrorInputStream();
        this.outputStream = new PipedOutputStream(this.inputStream);
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void start() {
        this.latch.countDown();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setLastModified(String lastModified) {
        if (lastModified != null && lastModified.length() > 0) {
            try {
                this.lastModified = DateUtil.parseDate((String)lastModified).getTime();
            }
            catch (DateUtil.DateParseException e) {
                this.lastModified = -1L;
            }
        }
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentLength(String contentLength) {
        if (contentLength != null && contentLength.length() > 0) {
            try {
                this.contentLength = Long.parseLong(contentLength);
            }
            catch (NumberFormatException e) {
                this.contentLength = -1L;
            }
        } else {
            this.contentLength = -1L;
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void fail(Throwable error) {
        this.error = error;
        this.inputStream.setError(error);
    }

    public Throwable getError() {
        return this.error;
    }
}

