/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.task.model.Content;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.model.ContentData;
import org.kie.internal.task.api.model.InternalTaskData;

@Transactional
@ApplicationScoped
public class TaskContentServiceImpl
implements TaskContentService {
    @Inject
    private JbpmServicesPersistenceManager pm;

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public long addContent(long taskId, Map<String, Object> params) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        long outputContentId = task.getTaskData().getOutputContentId();
        ContentImpl outputContent = (ContentImpl)this.pm.find(ContentImpl.class, (Object)outputContentId);
        long contentId = -1L;
        if (outputContent == null) {
            ContentDataImpl outputContentData = ContentMarshallerHelper.marshal(params, null);
            ContentImpl content = new ContentImpl(outputContentData.getContent());
            this.pm.persist((Object)content);
            ((InternalTaskData)task.getTaskData()).setOutput(content.getId(), (ContentData)outputContentData);
            contentId = content.getId();
        } else {
            Object unmarshalledObject = ContentMarshallerHelper.unmarshall(outputContent.getContent(), null);
            if (unmarshalledObject != null && unmarshalledObject instanceof Map) {
                ((Map)unmarshalledObject).putAll(params);
            }
            ContentDataImpl outputContentData = ContentMarshallerHelper.marshal(unmarshalledObject, null);
            outputContent.setContent(outputContentData.getContent());
            contentId = outputContentId;
        }
        return contentId;
    }

    public long addContent(long taskId, Content content) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        this.pm.persist((Object)content);
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(content.getId());
        return content.getId();
    }

    public void deleteContent(long taskId, long contentId) {
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        ((InternalTaskData)task.getTaskData()).setDocumentContentId(-1L);
        ContentImpl content = (ContentImpl)this.pm.find(ContentImpl.class, (Object)contentId);
        this.pm.remove((Object)content);
    }

    public List<Content> getAllContentByTaskId(long taskId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ContentImpl getContentById(long contentId) {
        return (ContentImpl)this.pm.find(ContentImpl.class, (Object)contentId);
    }
}

