/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BinaryHeapQueue;

public class BinaryHeapQueueAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 510L;
    private String name;
    private BinaryHeapQueue queue;
    private boolean active;
    private PropagationContext autoFocusActivator;
    private long activatedForRecency;
    private long clearedForRecency;

    public BinaryHeapQueueAgendaGroup() {
    }

    public BinaryHeapQueueAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        this.queue = ruleBase.getConfiguration().isPhreakEnabled() ? new BinaryHeapQueue(new PhreakConflictResolver()) : new BinaryHeapQueue(ruleBase.getConfiguration().getConflictResolver());
        this.clearedForRecency = -1L;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public Activation[] getAndClear() {
        return this.queue.getAndClear();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void add(Activation activation) {
        this.queue.enqueue(activation);
    }

    @Override
    public Activation getNext() {
        return this.queue.dequeue();
    }

    @Override
    public Activation peekNext() {
        return this.queue.peek();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean activate) {
        this.active = activate;
    }

    @Override
    public void setAutoFocusActivator(PropagationContext autoFocusActivator) {
        this.autoFocusActivator = autoFocusActivator;
    }

    @Override
    public PropagationContext getAutoFocusActivator() {
        return this.autoFocusActivator;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Activation[] getActivations() {
        return (Activation[])this.queue.toArray(new AgendaItem[this.queue.size()]);
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BinaryHeapQueueAgendaGroup)) {
            return false;
        }
        return ((BinaryHeapQueueAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Activation activation) {
        this.queue.dequeue(activation.getQueueIndex());
    }

    @Override
    public void setActivatedForRecency(long recency) {
        this.activatedForRecency = recency;
    }

    @Override
    public long getActivatedForRecency() {
        return this.activatedForRecency;
    }

    @Override
    public void setClearedForRecency(long recency) {
        this.clearedForRecency = recency;
    }

    @Override
    public long getClearedForRecency() {
        return this.clearedForRecency;
    }
}

