/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.time.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.BaseTimer;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.NumberUtils;
import org.kie.api.runtime.Calendars;

public class DurationTimer
extends BaseTimer
implements Timer,
Externalizable {
    private long duration;

    public DurationTimer() {
    }

    public DurationTimer(long duration) {
        this.duration = duration;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.duration);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.duration = in.readLong();
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public Trigger createTrigger(Activation item, InternalWorkingMemory wm) {
        long timestamp = wm.getTimerService().getCurrentTime();
        String[] calendarNames = item.getRule().getCalendars();
        Calendars calendars = wm.getCalendars();
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, LeftTuple leftTuple, DefaultJobHandle jh, String[] calendarNames, Calendars calendars, Declaration[][] declrs, InternalWorkingMemory wm) {
        return this.createTrigger(timestamp, calendarNames, calendars);
    }

    @Override
    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        long offset = timestamp + this.duration;
        if (NumberUtils.isAddOverflow(timestamp, this.duration, offset)) {
            return new PointInTimeTrigger(timestamp, calendarNames, calendars);
        }
        return new PointInTimeTrigger(offset, calendarNames, calendars);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DurationTimer other = (DurationTimer)obj;
        return this.duration == other.duration;
    }

    @Override
    public ConditionalElement clone() {
        return new DurationTimer(this.duration);
    }
}

