/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sonatype.guice.bean.reflect.FileEntryIterator;
import org.sonatype.guice.bean.reflect.GlobberStrategy;
import org.sonatype.guice.bean.reflect.ZipEntryIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResourceEnumeration
implements Enumeration<URL> {
    private static final Iterator<String> NO_ENTRIES = Collections.emptyList().iterator();
    private final URL[] urls;
    private final String subPath;
    private final GlobberStrategy globber;
    private final Object globPattern;
    private final boolean recurse;
    private int index;
    private URL currentURL;
    private boolean isFolder;
    private Iterator<String> entryNames = NO_ENTRIES;
    private String nextEntryName;

    ResourceEnumeration(String subPath, String glob, boolean recurse, URL[] urls) {
        this.subPath = ResourceEnumeration.normalizeSearchPath(subPath);
        this.globber = GlobberStrategy.selectFor(glob);
        this.globPattern = this.globber.compile(glob);
        this.recurse = recurse;
        this.urls = urls;
    }

    @Override
    public boolean hasMoreElements() {
        while (null == this.nextEntryName) {
            if (this.entryNames.hasNext()) {
                String name = this.entryNames.next();
                if (!this.matchesRequest(name)) continue;
                this.nextEntryName = name;
                continue;
            }
            if (this.index < this.urls.length) {
                this.currentURL = this.urls[this.index++];
                this.entryNames = this.scan(this.currentURL);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public URL nextElement() {
        if (this.hasMoreElements()) {
            String name = this.nextEntryName;
            this.nextEntryName = null;
            try {
                return this.isFolder ? new URL(this.currentURL, name) : new URL("jar:" + this.currentURL + "!/" + name);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        throw new NoSuchElementException();
    }

    private static String normalizeSearchPath(String path) {
        if (null == path || "/".equals(path)) {
            return "";
        }
        boolean echoSlash = false;
        StringBuilder buf = new StringBuilder();
        int length = path.length();
        for (int i = 0; i < length; ++i) {
            boolean isNotSlash;
            char c = path.charAt(i);
            boolean bl = isNotSlash = '/' != c;
            if (!echoSlash && !isNotSlash) continue;
            echoSlash = isNotSlash;
            buf.append(c);
        }
        if (echoSlash) {
            buf.append('/');
        }
        return buf.toString();
    }

    private Iterator<String> scan(URL url) {
        this.isFolder = url.getPath().endsWith("/");
        return this.isFolder ? new FileEntryIterator(url, this.subPath, this.recurse) : new ZipEntryIterator(url);
    }

    private boolean matchesRequest(String entryName) {
        if (entryName.endsWith("/") || !entryName.startsWith(this.subPath)) {
            return false;
        }
        if (!this.recurse && entryName.indexOf(47, this.subPath.length()) > 0) {
            return false;
        }
        return this.globber.matches(this.globPattern, entryName);
    }
}

