/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;

public class PerRequestRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<RuntimeEngine> local = new ThreadLocal();

    public PerRequestRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        activeManagers.add(identifier);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        if (local.get() != null) {
            return local.get();
        }
        RuntimeEngineImpl runtime = new RuntimeEngineImpl(this.factory.newKieSession(), this.taskServiceFactory.newTaskService());
        runtime.setManager((RuntimeManager)this);
        this.registerDisposeCallback(runtime, new DisposeSessionTransactionSynchronization((RuntimeManager)this, runtime));
        this.registerDisposeCallback(runtime, new DestroySessionTransactionSynchronization(runtime.getKieSession()));
        this.registerItems(runtime);
        this.attachManager(runtime);
        local.set(runtime);
        return runtime;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        RuntimeEngine runtimeInUse = local.get();
        if (runtimeInUse == null || runtimeInUse.getKieSession().getId() != ksession.getId()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        block2: {
            local.set(null);
            try {
                runtime.getKieSession().destroy();
            }
            catch (Exception e) {
                if (!(runtime instanceof Disposable)) break block2;
                ((Disposable)runtime).dispose();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.factory.close();
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }
}

