/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.util;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.transaction.AbstractUserTransaction;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.Synchronizations;
import org.jboss.solder.core.Veto;

@ApplicationScoped
@DefaultTransaction
@Veto
public class CMTBTMTransaction
extends AbstractUserTransaction {
    private BitronixTransactionManager btm;

    @Inject
    public void init(Synchronizations sync) {
        this.setSynchronizations(sync);
        this.btm = TransactionManagerServices.getTransactionManager();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.btm.begin();
        this.getSynchronizations().afterTransactionBegin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        boolean success = false;
        Synchronizations synchronizations = this.getSynchronizations();
        synchronizations.beforeTransactionCommit();
        try {
            this.btm.commit();
            success = true;
        }
        finally {
            synchronizations.afterTransactionCompletion(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.btm.rollback();
        }
        finally {
            this.getSynchronizations().afterTransactionCompletion(false);
        }
    }

    public int getStatus() throws SystemException {
        return this.btm.getStatus();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.btm.setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.btm.setTransactionTimeout(timeout);
    }

    public void registerSynchronization(Synchronization sync) {
        Synchronizations synchronizations = this.getSynchronizations();
        if (!synchronizations.isAwareOfContainerTransactions()) {
            throw new UnsupportedOperationException("cannot register synchronization with container transaction, use <transaction:ejb-transaction/>");
        }
        synchronizations.registerSynchronization(sync);
    }
}

