/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner.embedder;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.project.MavenProject;
import org.kie.scanner.embedder.MavenEmbedder;
import org.kie.scanner.embedder.MavenRequest;

public class MavenProjectLoader {
    public static MavenProject parseMavenPom(File pomFile) {
        if (!pomFile.exists()) {
            return null;
        }
        MavenRequest mavenRequest = new MavenRequest();
        mavenRequest.setPom(pomFile.getAbsolutePath());
        try {
            MavenEmbedder mavenEmbedder = new MavenEmbedder(Thread.currentThread().getContextClassLoader(), mavenRequest);
            return mavenEmbedder.readProject(pomFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenProject parseMavenPom(InputStream pomStream) {
        MavenRequest mavenRequest = new MavenRequest();
        try {
            MavenEmbedder mavenEmbedder = new MavenEmbedder(Thread.currentThread().getContextClassLoader(), mavenRequest);
            return mavenEmbedder.readProject(pomStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenProject loadMavenProject() {
        return MavenProjectHolder.mavenProject;
    }

    private static class MavenProjectHolder {
        private static final MavenProject mavenProject = MavenProjectHolder.loadMavenProject();

        private MavenProjectHolder() {
        }

        private static MavenProject loadMavenProject() {
            File pomFile = new File("pom.xml");
            return MavenProjectLoader.parseMavenPom(pomFile);
        }
    }
}

