/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.servlet.resource.WebResourceLocationProvider;
import org.jboss.solder.util.Sortable;
import org.jboss.solder.util.service.ServiceLoader;

public class WebResourceLocator {
    private final Logger log = Logger.getLogger(WebResourceLocator.class);

    public InputStream getWebResource(String path) {
        block3: {
            URL resourceLocation = this.getWebResourceUrl(path);
            if (resourceLocation != null) {
                try {
                    return resourceLocation.openStream();
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Error opening: " + resourceLocation.toString(), e);
                }
            }
        }
        return null;
    }

    public URL getWebResourceUrl(String path) {
        ArrayList<WebResourceLocationProvider> providers = new ArrayList<WebResourceLocationProvider>();
        Iterator<WebResourceLocationProvider> iterator = ServiceLoader.load(WebResourceLocationProvider.class).iterator();
        while (iterator.hasNext()) {
            providers.add(iterator.next());
        }
        Collections.sort(providers, new Sortable.Comparator());
        ClassLoader classLoader = WebResourceLocator.class.getClassLoader();
        for (WebResourceLocationProvider provider : providers) {
            URL resourceLocation = provider.getWebResource(path, classLoader);
            if (resourceLocation == null) continue;
            return resourceLocation;
        }
        return null;
    }
}

