/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EndEventHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        EndNode node = new EndNode();
        node.setTerminate(false);
        return node;
    }

    public Class generateNodeFor() {
        return EndNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        super.handleNode(node, element, uri, localName, parser);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("terminateEventDefinition".equals(nodeName)) {
                this.handleTerminateNode(node, element, uri, localName, parser);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.handleMessageNode(node, element, uri, localName, parser);
                continue;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setTerminateParent(true);
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                super.handleNode(node, element, uri, localName, parser);
                this.handleErrorNode(node, element, uri, localName, parser);
                break;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                FaultNode faultNode = new FaultNode();
                faultNode.setId(node.getId());
                faultNode.setName(node.getName());
                faultNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = faultNode;
                super.handleNode(node, element, uri, localName, parser);
                this.handleEscalationNode(node, element, uri, localName, parser);
                break;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleCompensationNode(node, element, uri, localName, parser);
            break;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        return node;
    }

    public void handleTerminateNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ((EndNode)node).setTerminate(true);
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"terminateEventDefinition".equals(nodeName)) continue;
            String scope = ((Element)xmlNode).getAttribute("scope");
            if ("process".equalsIgnoreCase(scope)) {
                endNode.setScope(1);
                continue;
            }
            endNode.setScope(0);
        }
    }

    public void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readEndDataInputAssociation(xmlNode, endNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName)) continue;
            String signalName = ((Element)xmlNode).getAttribute("signalRef");
            String variable = (String)endNode.getMetaData("MappingVariable");
            ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
            actions.add(new DroolsConsequenceAction("mvel", "kcontext.getKnowledgeRuntime().signalEvent(\"" + signalName + "\", " + (variable == null ? "null" : variable) + ")"));
            endNode.setActions("onEntry", actions);
        }
    }

    public void handleMessageNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        EndNode endNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readEndDataInputAssociation(xmlNode, endNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            String variable = (String)endNode.getMetaData("MappingVariable");
            endNode.setMetaData("MessageType", (Object)message.getType());
            ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
            actions.add(new DroolsConsequenceAction("java", "org.drools.core.process.instance.impl.WorkItemImpl workItem = new org.drools.core.process.instance.impl.WorkItemImpl();" + EOL + "workItem.setName(\"Send Task\");" + EOL + "workItem.setParameter(\"MessageType\", \"" + message.getType() + "\");" + EOL + (variable == null ? "" : "workItem.setParameter(\"Message\", " + variable + ");" + EOL) + "((org.drools.core.process.instance.WorkItemManager) kcontext.getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(workItem);"));
            endNode.setActions("onEntry", actions);
        }
    }

    protected void readEndDataInputAssociation(org.w3c.dom.Node xmlNode, EndNode endNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String eventVariable = subNode.getTextContent();
        if (eventVariable != null && eventVariable.trim().length() > 0) {
            endNode.setMetaData("MappingVariable", (Object)eventVariable);
        }
    }

    public void handleErrorNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readFaultDataInputAssociation(xmlNode, faultNode);
                continue;
            }
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            Map errors = (Map)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = (Error)errors.get(errorRef);
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            faultNode.setFaultName(error.getErrorCode());
            faultNode.setTerminateParent(true);
        }
    }

    public void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        FaultNode faultNode = (FaultNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String escalationRef;
            String nodeName = xmlNode.getNodeName();
            if ("dataInputAssociation".equals(nodeName)) {
                this.readFaultDataInputAssociation(xmlNode, faultNode);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName) || (escalationRef = ((Element)xmlNode).getAttribute("escalationRef")) == null || escalationRef.trim().length() <= 0) continue;
            Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("Escalations");
            if (escalations == null) {
                throw new IllegalArgumentException("No escalations found");
            }
            Escalation escalation = (Escalation)escalations.get(escalationRef);
            if (escalation == null) {
                throw new IllegalArgumentException("Could not find escalation " + escalationRef);
            }
            faultNode.setFaultName(escalation.getEscalationCode());
        }
    }

    protected void readFaultDataInputAssociation(org.w3c.dom.Node xmlNode, FaultNode faultNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String faultVariable = subNode.getTextContent();
        faultNode.setFaultVariable(faultVariable);
    }

    public void handleCompensationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        EndNode actionNode = (EndNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String activityRef;
            String nodeName = xmlNode.getNodeName();
            if (!"compensateEventDefinition".equals(nodeName) || (activityRef = ((Element)xmlNode).getAttribute("activityRef")) == null || activityRef.trim().length() <= 0) continue;
            actionNode.setMetaData("Compensate", (Object)activityRef);
            ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
            actions.add(new DroolsConsequenceAction("java", "kcontext.getProcessInstance().signalEvent(\"Compensate-" + activityRef + "\", null);"));
            actionNode.setActions("onEntry", actions);
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

