/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.jbpm.runtime.manager.impl.mapper.JPAMapper;
import org.jbpm.services.task.identity.MvelUserGroupCallbackImpl;

public class DefaultRuntimeEnvironment
extends SimpleRuntimeEnvironment {
    public DefaultRuntimeEnvironment() {
        this(null, (GlobalSchedulerService)new ThreadPoolSchedulerService(3));
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf) {
        this(emf, (GlobalSchedulerService)new ThreadPoolSchedulerService(3));
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, GlobalSchedulerService globalSchedulerService) {
        super(new DefaultRegisterableItemsFactory());
        this.emf = emf;
        this.schedulerService = globalSchedulerService;
        this.usePersistence = true;
        this.userGroupCallback = new MvelUserGroupCallbackImpl();
    }

    public DefaultRuntimeEnvironment(EntityManagerFactory emf, boolean usePersistence) {
        this(emf, null);
        this.usePersistence = usePersistence;
        this.emf = emf;
        this.userGroupCallback = new MvelUserGroupCallbackImpl();
    }

    @Override
    public void init() {
        if (this.emf == null) {
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
        this.addToEnvironment("org.kie.api.persistence.jpa.EntityManagerFactory", this.emf);
        if (this.mapper == null) {
            this.mapper = this.usePersistence ? new JPAMapper(this.emf) : new InMemoryMapper();
        }
    }
}

