/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.tx.DestroySessionTransactionSynchronization;
import org.jbpm.runtime.manager.impl.tx.DisposeSessionTransactionSynchronization;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class PerProcessInstanceRuntimeManager
extends AbstractRuntimeManager {
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;
    private static ThreadLocal<Map<Object, RuntimeEngine>> local = new ThreadLocal();
    private Mapper mapper;

    public PerProcessInstanceRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.mapper = environment.getMapper();
        activeManagers.add(identifier);
    }

    public RuntimeEngine getRuntimeEngine(Context<?> context) {
        Object contextId = context.getContextId();
        KieSession ksession = null;
        Integer ksessionId = null;
        if (contextId == null || context instanceof EmptyContext) {
            ksession = this.factory.newKieSession();
            ksessionId = ksession.getId();
        } else {
            RuntimeEngine localRuntime = this.findLocalRuntime(contextId);
            if (localRuntime != null) {
                return localRuntime;
            }
            ksessionId = this.mapper.findMapping(context);
            if (ksessionId == null) {
                throw new SessionNotFoundException("No session found for context " + context.getContextId());
            }
            ksession = this.factory.findKieSessionById(ksessionId);
        }
        RuntimeEngineImpl runtime = new RuntimeEngineImpl(ksession, this.taskServiceFactory.newTaskService());
        runtime.setManager((RuntimeManager)this);
        this.registerDisposeCallback(runtime, new DisposeSessionTransactionSynchronization((RuntimeManager)this, runtime));
        this.registerItems(runtime);
        this.attachManager(runtime);
        this.saveLocalRuntime(contextId, runtime);
        ksession.addEventListener((ProcessEventListener)new MaintainMappingListener(ksessionId, runtime));
        return runtime;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (context == null || context.getContextId() == null) {
            return;
        }
        Integer ksessionId = this.mapper.findMapping(context);
        if (ksessionId == null) {
            Object contextId = this.mapper.findContextId(Integer.valueOf(ksession.getId()));
            if (contextId != null) {
                throw new IllegalStateException("KieSession with id " + ksession.getId() + " is already used by another context");
            }
            return;
        }
        if (ksession.getId() != ksessionId.intValue()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
        this.removeLocalRuntime(runtime);
        if (runtime instanceof Disposable) {
            ((Disposable)runtime).dispose();
        }
    }

    @Override
    public void close() {
        super.close();
        this.factory.close();
    }

    public boolean validate(Integer ksessionId, Long processInstanceId) {
        Integer mapped = this.mapper.findMapping((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        return mapped == ksessionId;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected RuntimeEngine findLocalRuntime(Object processInstanceId) {
        if (processInstanceId == null) {
            return null;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            return null;
        }
        return map.get(processInstanceId);
    }

    protected void saveLocalRuntime(Object processInstanceId, RuntimeEngine runtime) {
        if (processInstanceId == null) {
            return;
        }
        Map<Object, RuntimeEngine> map = local.get();
        if (map == null) {
            map = new HashMap<Object, RuntimeEngine>();
            local.set(map);
        }
        map.put(processInstanceId, runtime);
    }

    protected void removeLocalRuntime(RuntimeEngine runtime) {
        Map<Object, RuntimeEngine> map = local.get();
        Object keyToRemove = -1L;
        if (map != null) {
            for (Map.Entry<Object, RuntimeEngine> entry : map.entrySet()) {
                if (!runtime.equals(entry.getValue())) continue;
                keyToRemove = entry.getKey();
                break;
            }
            map.remove(keyToRemove);
        }
    }

    private class MaintainMappingListener
    extends DefaultProcessEventListener {
        private Integer ksessionId;
        private RuntimeEngine runtime;

        MaintainMappingListener(Integer ksessionId, RuntimeEngine runtime) {
            this.ksessionId = ksessionId;
            this.runtime = runtime;
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.removeMapping((Context)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()));
            PerProcessInstanceRuntimeManager.this.removeLocalRuntime(this.runtime);
            PerProcessInstanceRuntimeManager.this.registerDisposeCallback(this.runtime, new DestroySessionTransactionSynchronization(this.runtime.getKieSession()));
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            PerProcessInstanceRuntimeManager.this.mapper.saveMapping((Context)ProcessInstanceIdContext.get((Long)event.getProcessInstance().getId()), this.ksessionId);
            PerProcessInstanceRuntimeManager.this.saveLocalRuntime(event.getProcessInstance().getId(), this.runtime);
        }
    }
}

