/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.kie.services.impl.model.NodeInstanceDesc;
import org.jbpm.kie.services.impl.model.ProcessDesc;
import org.jbpm.kie.services.impl.model.ProcessInstanceDesc;
import org.jbpm.kie.services.impl.model.VariableStateDesc;
import org.jbpm.services.task.wih.RuntimeFinder;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;

@ApplicationScoped
@Transactional
public class RuntimeDataServiceImpl
implements RuntimeDataService,
RuntimeFinder {
    @Inject
    private JbpmServicesPersistenceManager pm;
    private Set<ProcessDesc> availableProcesses = new HashSet<ProcessDesc>();

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void indexOnDeploy(@Observes @Deploy DeploymentEvent event) {
        Collection<ProcessDesc> assets = event.getDeployedUnit().getDeployedAssets();
        this.availableProcesses.addAll(assets);
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(event.getDeploymentId()), outputCollection);
        this.availableProcesses.removeAll(outputCollection);
    }

    @Override
    public Collection<ProcessDesc> getProcessesByDeploymentId(String deploymentId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByDeploymentIdPredicate(deploymentId), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public Collection<ProcessDesc> getProcessesByFilter(String filter) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new RegExPredicate("^.*" + filter + ".*$"), outputCollection);
        return Collections.unmodifiableCollection(outputCollection);
    }

    @Override
    public ProcessDesc getProcessById(String processId) {
        HashSet outputCollection = new HashSet();
        CollectionUtils.select(this.availableProcesses, (Predicate)new ByProcessIdPredicate(processId), outputCollection);
        if (!outputCollection.isEmpty()) {
            return (ProcessDesc)outputCollection.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ProcessDesc> getProcesses() {
        return Collections.unmodifiableCollection(this.availableProcesses);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances() {
        List processInstances = (List)this.pm.queryInTransaction("getProcessInstances");
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstances(List<Integer> states, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByDeploymentId(String deploymentId, List<Integer> states) {
        List processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByDeploymentId", (Map)this.pm.addParametersToMap(new Object[]{"externalId", deploymentId, "states", states}));
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessDefinition(String processDefId) {
        List processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessDefinition", (Map)this.pm.addParametersToMap(new Object[]{"processDefId", processDefId}));
        return processInstances;
    }

    @Override
    public ProcessInstanceDesc getProcessInstanceById(long processId) {
        List processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceById", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "maxResults", 1}));
        return (ProcessInstanceDesc)processInstances.get(0);
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessId(List<Integer> states, String processId, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processId", processId + "%");
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessIdAndStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessIdAndStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<ProcessInstanceDesc> getProcessInstancesByProcessName(List<Integer> states, String processName, String initiator) {
        List processInstances = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("states", states);
        params.put("processName", processName + "%");
        if (initiator == null) {
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessNameAndStatus", params);
        } else {
            params.put("initiator", initiator);
            processInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstancesByProcessNameAndStatusAndInitiator", params);
        }
        return processInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String deploymentId, long processId) {
        return this.getProcessInstanceHistory(deploymentId, processId, false);
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceHistory(String deploymentId, long processId, boolean completed) {
        HashMap params = this.pm.addParametersToMap(new Object[]{"processId", processId, "externalId", deploymentId});
        if (completed) {
            params.put("type", 1);
        } else {
            params.put("type", 0);
        }
        List nodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceHistory", (Map)params);
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceFullHistory(String deploymentId, long processId) {
        List nodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceFullHistory", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "externalId", deploymentId}));
        return nodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceActiveNodes(String deploymentId, long processId) {
        List activeNodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceActiveNodes", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "externalId", deploymentId}));
        return activeNodeInstances;
    }

    @Override
    public Collection<NodeInstanceDesc> getProcessInstanceCompletedNodes(String deploymentId, long processId) {
        List completedNodeInstances = (List)this.pm.queryWithParametersInTransaction("getProcessInstanceCompletedNodes", (Map)this.pm.addParametersToMap(new Object[]{"processId", processId, "externalId", deploymentId}));
        return completedNodeInstances;
    }

    @Override
    public Collection<VariableStateDesc> getVariablesCurrentState(long processInstanceId) {
        List variablesState = (List)this.pm.queryWithParametersInTransaction("getVariablesCurrentState", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId}));
        return variablesState;
    }

    @Override
    public Collection<VariableStateDesc> getVariableHistory(long processInstanceId, String variableId) {
        List variablesState = (List)this.pm.queryWithParametersInTransaction("getVariableHistory", (Map)this.pm.addParametersToMap(new Object[]{"processInstanceId", processInstanceId, "variableId", variableId}));
        return variablesState;
    }

    public String findName(long id) {
        ProcessInstanceDesc piDesc = this.getProcessInstanceById(id);
        return piDesc.getDeploymentId();
    }

    private class ByProcessIdPredicate
    implements Predicate {
        private String processId;

        private ByProcessIdPredicate(String processId) {
            this.processId = processId;
        }

        public boolean evaluate(Object object) {
            ProcessDesc pDesc;
            return object instanceof ProcessDesc && (pDesc = (ProcessDesc)object).getId().equals(this.processId);
        }
    }

    private class ByDeploymentIdPredicate
    implements Predicate {
        private String deploymentId;

        private ByDeploymentIdPredicate(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public boolean evaluate(Object object) {
            ProcessDesc pDesc;
            return object instanceof ProcessDesc && (pDesc = (ProcessDesc)object).getDeploymentId().equals(this.deploymentId);
        }
    }

    private class RegExPredicate
    implements Predicate {
        private String pattern;

        private RegExPredicate(String pattern) {
            this.pattern = pattern;
        }

        public boolean evaluate(Object object) {
            ProcessDesc pDesc;
            return object instanceof ProcessDesc && ((pDesc = (ProcessDesc)object).getId().matches(this.pattern) || pDesc.getName().matches(this.pattern));
        }
    }
}

