/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.securechat;

import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.ssl.SslHandler;

public class SecureChatServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(SecureChatServerHandler.class.getName());
    static final ChannelGroup channels = new DefaultChannelGroup();

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SslHandler sslHandler = ctx.getPipeline().get(SslHandler.class);
        ChannelFuture handshakeFuture = sslHandler.handshake();
        handshakeFuture.addListener(new Greeter(sslHandler));
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        channels.remove(e.getChannel());
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        String request = (String)e.getMessage();
        for (Channel c : channels) {
            if (c != e.getChannel()) {
                c.write("[" + e.getChannel().getRemoteAddress() + "] " + request + '\n');
                continue;
            }
            c.write("[you] " + request + '\n');
        }
        if (request.toLowerCase().equals("bye")) {
            e.getChannel().close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }

    private static final class Greeter
    implements ChannelFutureListener {
        private final SslHandler sslHandler;

        Greeter(SslHandler sslHandler) {
            this.sslHandler = sslHandler;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                future.getChannel().write("Welcome to " + InetAddress.getLocalHost().getHostName() + " secure chat service!\n");
                future.getChannel().write("Your session is protected by " + this.sslHandler.getEngine().getSession().getCipherSuite() + " cipher suite.\n");
                channels.add(future.getChannel());
            } else {
                future.getChannel().close();
            }
        }
    }
}

