/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.netty.handler.codec.http.HttpCodecUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringDecoder {
    private static final Pattern PARAM_PATTERN = Pattern.compile("([^=]*)=([^&]*)&*");
    private final Charset charset;
    private final String uri;
    private String path;
    private final Map<String, List<String>> params = new HashMap<String, List<String>>();

    public QueryStringDecoder(String uri) {
        this(uri, HttpCodecUtil.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(String uri, Charset charset) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri;
        this.charset = charset;
    }

    @Deprecated
    public QueryStringDecoder(String uri, String charset) {
        this(uri, Charset.forName(charset));
    }

    public QueryStringDecoder(URI uri) {
        this(uri, HttpCodecUtil.DEFAULT_CHARSET);
    }

    public QueryStringDecoder(URI uri, Charset charset) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.uri = uri.toASCIIString();
        this.charset = charset;
    }

    @Deprecated
    public QueryStringDecoder(URI uri, String charset) {
        this(uri, Charset.forName(charset));
    }

    public String getPath() {
        if (this.path == null) {
            if (this.uri.contains("?")) {
                this.decode();
            } else {
                this.path = this.uri;
            }
        }
        return this.path;
    }

    public Map<String, List<String>> getParameters() {
        if (this.path == null) {
            if (this.uri.contains("?")) {
                this.decode();
            } else {
                this.path = this.uri;
            }
        }
        return this.params;
    }

    private void decode() {
        int pathEndPos = this.uri.indexOf(63);
        if (pathEndPos < 0) {
            this.path = this.uri;
        } else {
            this.path = this.uri.substring(0, pathEndPos);
            this.decodeParams(this.uri.substring(pathEndPos + 1));
        }
    }

    private void decodeParams(String s) {
        Matcher m = PARAM_PATTERN.matcher(s);
        int pos = 0;
        while (m.find(pos)) {
            pos = m.end();
            String key = QueryStringDecoder.decodeComponent(m.group(1), this.charset);
            String value = QueryStringDecoder.decodeComponent(m.group(2), this.charset);
            List<String> values = this.params.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.params.put(key, values);
            }
            values.add(value);
        }
    }

    private static String decodeComponent(String s, Charset charset) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedCharsetException(charset.name());
        }
    }
}

