/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.uptime;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class UptimeClientHandler
extends SimpleChannelUpstreamHandler {
    final ClientBootstrap bootstrap;
    private final Timer timer;
    private long startTime = -1L;

    public UptimeClientHandler(ClientBootstrap bootstrap, Timer timer) {
        this.bootstrap = bootstrap;
        this.timer = timer;
    }

    InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.bootstrap.getOption("remoteAddress");
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.println("Disconnected from: " + this.getRemoteAddress());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.println("Sleeping for: 5s");
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                UptimeClientHandler.this.println("Reconnecting to: " + UptimeClientHandler.this.getRemoteAddress());
                UptimeClientHandler.this.bootstrap.connect();
            }
        }, 5L, TimeUnit.SECONDS);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (this.startTime < 0L) {
            this.startTime = System.currentTimeMillis();
        }
        this.println("Connected to: " + this.getRemoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Throwable cause = e.getCause();
        if (cause instanceof ConnectException) {
            this.startTime = -1L;
            this.println("Failed to connect: " + cause.getMessage());
        }
        ctx.getChannel().close();
    }

    void println(String msg) {
        if (this.startTime < 0L) {
            System.err.format("[SERVER IS DOWN] %s%n", msg);
        } else {
            System.err.format("[UPTIME: %5ds] %s%n", (System.currentTimeMillis() - this.startTime) / 1000L, msg);
        }
    }
}

