/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.command;

import java.util.List;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.command.AbstractHistoryLogCommand;
import org.kie.internal.command.Context;

public class FindNodeInstancesCommand
extends AbstractHistoryLogCommand<List<NodeInstanceLog>> {
    private static final long serialVersionUID = 9066179664390664420L;
    private final long processInstanceId;
    private final String nodeId;

    public FindNodeInstancesCommand(long processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = null;
    }

    public FindNodeInstancesCommand(long processInstanceId, String nodeId) {
        this.processInstanceId = processInstanceId;
        this.nodeId = nodeId;
        if (nodeId == null || nodeId.isEmpty()) {
            throw new IllegalArgumentException("The nodeId field must not be null or empty.");
        }
    }

    public List<NodeInstanceLog> execute(Context cntxt) {
        this.setLogEnvironment(cntxt);
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return JPAProcessInstanceDbLog.findNodeInstances(this.processInstanceId);
        }
        return JPAProcessInstanceDbLog.findNodeInstances(this.processInstanceId, this.nodeId);
    }

    public String toString() {
        if (this.nodeId == null || this.nodeId.isEmpty()) {
            return "JPAProcessInstanceDbLog.findNodeInstances(" + this.processInstanceId + ")";
        }
        return "JPAProcessInstanceDbLog.findNodeInstances(" + this.processInstanceId + ", " + this.nodeId + ")";
    }
}

