/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.inject.Inject;
import javax.transaction.SystemException;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.jboss.solder.exception.control.CaughtException;
import org.jboss.solder.exception.control.Handles;
import org.jboss.solder.exception.control.HandlesExceptions;
import org.jboss.solder.exception.control.TraversalMode;
import org.jboss.solder.logging.Logger;

@HandlesExceptions
public class SimpleTransactionExceptionHandler {
    @Inject
    @DefaultTransaction
    private SeamTransaction tx;
    private final Logger log = Logger.getLogger(SimpleTransactionExceptionHandler.class);

    public void markTransactionRollback(@Handles(precedence=-100, during=TraversalMode.BREADTH_FIRST) CaughtException<Throwable> t) {
        try {
            switch (this.tx.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    this.tx.setRollbackOnly();
                    break;
                }
            }
        }
        catch (SystemException e) {
            this.log.warn((Object)"Could not set transaction to rollback", (Throwable)e);
        }
        t.rethrow();
    }
}

