/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.journal.TransactionLogCursor;
import bitronix.tm.journal.TransactionLogHeader;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.utils.Uid;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLogAppender {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogAppender.class);
    public static final int END_RECORD = 2020504642;
    private final File file;
    private final RandomAccessFile randomeAccessFile;
    private final FileChannel fc;
    private final FileLock lock;
    private final TransactionLogHeader header;
    private final long maxFileLength;
    private final AtomicInteger outstandingWrites;
    private final HashMap<Uid, Set<String>> danglingRecords;
    private long position;

    public TransactionLogAppender(File file, long maxFileLength) throws IOException {
        this.file = file;
        this.randomeAccessFile = new RandomAccessFile(file, "rw");
        this.fc = this.randomeAccessFile.getChannel();
        this.header = new TransactionLogHeader(this.fc, maxFileLength);
        this.maxFileLength = maxFileLength;
        this.lock = this.fc.tryLock(0L, 4L, false);
        if (this.lock == null) {
            throw new IOException("transaction log file " + file.getName() + " is locked. Is another instance already running?");
        }
        this.outstandingWrites = new AtomicInteger();
        this.danglingRecords = new HashMap();
        this.position = this.header.getPosition();
    }

    protected boolean setPositionAndAdvance(TransactionLogRecord tlog) throws IOException {
        int tlogSize = tlog.calculateTotalRecordSize();
        if (this.position + (long)tlogSize > this.maxFileLength) {
            return true;
        }
        long writePosition = this.position;
        this.position += (long)tlogSize;
        tlog.setWritePosition(writePosition);
        this.outstandingWrites.incrementAndGet();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeLog(TransactionLogRecord tlog) throws IOException {
        try {
            int status = tlog.getStatus();
            Uid gtrid = tlog.getGtrid();
            int recordSize = tlog.calculateTotalRecordSize();
            ByteBuffer buf = ByteBuffer.allocate(recordSize);
            buf.putInt(tlog.getStatus());
            buf.putInt(tlog.getRecordLength());
            buf.putInt(tlog.getHeaderLength());
            buf.putLong(tlog.getTime());
            buf.putInt(tlog.getSequenceNumber());
            buf.putInt(tlog.getCrc32());
            buf.put((byte)gtrid.getArray().length);
            buf.put(gtrid.getArray());
            Set<String> uniqueNames = tlog.getUniqueNames();
            buf.putInt(uniqueNames.size());
            for (String uniqueName : uniqueNames) {
                buf.putShort((short)uniqueName.length());
                buf.put(uniqueName.getBytes());
            }
            buf.putInt(tlog.getEndRecord());
            buf.flip();
            if (log.isDebugEnabled()) {
                log.debug("between " + tlog.getWritePosition() + " and " + tlog.getWritePosition() + tlog.calculateTotalRecordSize() + ", writing " + tlog);
            }
            long writePosition = tlog.getWritePosition();
            while (buf.hasRemaining()) {
                this.fc.write(buf, writePosition + (long)buf.position());
            }
            this.trackOutstanding(status, gtrid, uniqueNames);
            Object var10_10 = null;
            if (this.outstandingWrites.decrementAndGet() != 0) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (this.outstandingWrites.decrementAndGet() != 0) throw throwable;
            this.header.setPosition(this.position);
            throw throwable;
        }
        this.header.setPosition(this.position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TransactionLogRecord> getDanglingLogs() {
        HashMap<Uid, Set<String>> hashMap = this.danglingRecords;
        synchronized (hashMap) {
            ArrayList<Uid> sortedUids = new ArrayList<Uid>(this.danglingRecords.keySet());
            Collections.sort(sortedUids, new Comparator<Uid>(){

                @Override
                public int compare(Uid uid1, Uid uid2) {
                    return Integer.valueOf(uid1.extractSequence()).compareTo(uid2.extractSequence());
                }
            });
            ArrayList<TransactionLogRecord> outstandingLogs = new ArrayList<TransactionLogRecord>(this.danglingRecords.size());
            for (Uid uid : sortedUids) {
                Set<String> uniqueNames = this.danglingRecords.get(uid);
                outstandingLogs.add(new TransactionLogRecord(8, uid, uniqueNames));
            }
            return outstandingLogs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearDanglingLogs() {
        HashMap<Uid, Set<String>> hashMap = this.danglingRecords;
        synchronized (hashMap) {
            this.danglingRecords.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackOutstanding(int status, Uid gtrid, Set<String> uniqueNames) {
        if (uniqueNames.isEmpty()) {
            return;
        }
        switch (status) {
            case 8: {
                HashMap<Uid, Set<String>> hashMap = this.danglingRecords;
                synchronized (hashMap) {
                    Set<String> outstanding = this.danglingRecords.get(gtrid);
                    if (outstanding == null) {
                        outstanding = new TreeSet<String>(uniqueNames);
                        this.danglingRecords.put(gtrid, outstanding);
                    }
                    outstanding.addAll(uniqueNames);
                    break;
                }
            }
            case 3: 
            case 4: 
            case 5: {
                HashMap<Uid, Set<String>> hashMap = this.danglingRecords;
                synchronized (hashMap) {
                    Set<String> outstanding = this.danglingRecords.get(gtrid);
                    if (outstanding != null && outstanding.removeAll(uniqueNames) && outstanding.isEmpty()) {
                        this.danglingRecords.remove(gtrid);
                    }
                    break;
                }
            }
        }
    }

    void rewind() throws IOException {
        this.header.rewind();
        this.position = this.header.getPosition();
    }

    long getTimestamp() {
        return this.header.getTimestamp();
    }

    void setTimestamp(long timestamp) throws IOException {
        this.header.setTimestamp(timestamp);
    }

    public byte getState() {
        return this.header.getState();
    }

    public void setState(byte state) throws IOException {
        this.header.setState(state);
    }

    public long getPosition() {
        return this.position;
    }

    protected void close() throws IOException {
        this.header.setState((byte)0);
        this.fc.force(false);
        if (this.lock != null) {
            this.lock.release();
        }
        this.fc.close();
        this.randomeAccessFile.close();
    }

    protected TransactionLogCursor getCursor() throws IOException {
        return new TransactionLogCursor(this.file);
    }

    protected void force() throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("forcing log writing");
        }
        this.fc.force(false);
        if (log.isDebugEnabled()) {
            log.debug("done forcing log");
        }
    }

    public String toString() {
        return "a TransactionLogAppender on " + this.file.getName();
    }
}

