/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.journal;

import bitronix.tm.utils.Decoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogHeader {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogHeader.class);
    public static final int FORMAT_ID_HEADER = 0;
    public static final int TIMESTAMP_HEADER = 4;
    public static final int STATE_HEADER = 12;
    public static final int CURRENT_POSITION_HEADER = 13;
    public static final int HEADER_LENGTH = 21;
    public static final byte CLEAN_LOG_STATE = 0;
    public static final byte UNCLEAN_LOG_STATE = -1;
    private final FileChannel fc;
    private final long maxFileLength;
    private volatile int formatId;
    private volatile long timestamp;
    private volatile byte state;
    private volatile long position;

    public TransactionLogHeader(FileChannel fc, long maxFileLength) throws IOException {
        this.fc = fc;
        this.maxFileLength = maxFileLength;
        fc.position(0L);
        ByteBuffer buf = ByteBuffer.allocate(21);
        while (buf.hasRemaining()) {
            this.fc.read(buf);
        }
        buf.flip();
        this.formatId = buf.getInt();
        this.timestamp = buf.getLong();
        this.state = buf.get();
        this.position = buf.getLong();
        fc.position(this.position);
        if (log.isDebugEnabled()) {
            log.debug("read header " + this);
        }
    }

    public int getFormatId() {
        return this.formatId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte getState() {
        return this.state;
    }

    public long getPosition() {
        return this.position;
    }

    public void setFormatId(int formatId) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(formatId);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 0 + buf.position());
        }
        this.formatId = formatId;
    }

    public void setTimestamp(long timestamp) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(timestamp);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 4 + buf.position());
        }
        this.timestamp = timestamp;
    }

    public void setState(byte state) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(1);
        buf.put(state);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 12 + buf.position());
        }
        this.state = state;
    }

    public void setPosition(long position) throws IOException {
        if (position < 21L) {
            throw new IOException("invalid position " + position + " (too low)");
        }
        if (position > this.maxFileLength) {
            throw new IOException("invalid position " + position + " (too high)");
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(position);
        buf.flip();
        while (buf.hasRemaining()) {
            this.fc.write(buf, 13 + buf.position());
        }
        this.position = position;
        this.fc.position(position);
    }

    public void rewind() throws IOException {
        this.setPosition(21L);
    }

    public String toString() {
        return "a Bitronix TransactionLogHeader with timestamp=" + this.timestamp + ", state=" + Decoder.decodeHeaderState(this.state) + ", position=" + this.position;
    }
}

