/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.resource.jdbc.LruEvictionListener;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LruStatementCache {
    private static final Logger log = LoggerFactory.getLogger(LruStatementCache.class);
    private int maxSize;
    private final LinkedHashMap<CacheKey, StatementTracker> cache;
    private final List<LruEvictionListener> evictionListners;
    private int size;

    public LruStatementCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new LinkedHashMap(maxSize, 0.75f, true);
        this.evictionListners = new CopyOnWriteArrayList<LruEvictionListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement get(CacheKey key) {
        LinkedHashMap<CacheKey, StatementTracker> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            StatementTracker cached = this.cache.get(key);
            if (cached != null) {
                cached.usageCount++;
                if (log.isDebugEnabled()) {
                    log.debug("delivered from cache with usage count " + cached.usageCount + " statement <" + key + ">");
                }
                return cached.statement;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement put(CacheKey key, PreparedStatement statement) {
        LinkedHashMap<CacheKey, StatementTracker> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            if (this.maxSize < 1) {
                return null;
            }
            StatementTracker cached = this.cache.get(key);
            if (cached == null) {
                if (log.isDebugEnabled()) {
                    log.debug("adding to cache statement <" + key + ">");
                }
                this.cache.put(key, new StatementTracker(statement));
                ++this.size;
            } else {
                cached.usageCount--;
                statement = cached.statement;
                if (log.isDebugEnabled()) {
                    log.debug("returning to cache statement <" + key + "> with usage count " + cached.usageCount);
                }
            }
            if (this.size > this.maxSize) {
                this.tryEviction();
            }
            return statement;
        }
    }

    public void addEvictionListener(LruEvictionListener listener) {
        this.evictionListners.add(listener);
    }

    public void removeEvictionListener(LruEvictionListener listener) {
        this.evictionListners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        LinkedHashMap<CacheKey, StatementTracker> linkedHashMap = this.cache;
        synchronized (linkedHashMap) {
            Iterator<Map.Entry<CacheKey, StatementTracker>> it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CacheKey, StatementTracker> entry = it.next();
                StatementTracker tracker = entry.getValue();
                it.remove();
                this.fireEvictionEvent(tracker.statement);
            }
            this.cache.clear();
            this.size = 0;
        }
    }

    private void tryEviction() {
        Iterator<Map.Entry<CacheKey, StatementTracker>> it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<CacheKey, StatementTracker> entry = it.next();
            StatementTracker tracker = entry.getValue();
            if (tracker.usageCount != 0) continue;
            it.remove();
            --this.size;
            CacheKey key = entry.getKey();
            if (log.isDebugEnabled()) {
                log.debug("evicting from cache statement <" + key + "> " + entry.getValue().statement);
            }
            this.fireEvictionEvent(tracker.statement);
            if (this.size > this.maxSize) continue;
            break;
        }
    }

    private void fireEvictionEvent(Object value) {
        for (LruEvictionListener listener : this.evictionListners) {
            listener.onEviction(value);
        }
    }

    private static final class StatementTracker {
        private final PreparedStatement statement;
        private int usageCount;

        private StatementTracker(PreparedStatement stmt) {
            this.statement = stmt;
            this.usageCount = 1;
        }
    }

    public static final class CacheKey {
        private String sql;
        private int resultSetType = 1003;
        private int resultSetConcurrency = 1007;
        private Integer resultSetHoldability;
        private Integer autoGeneratedKeys;
        private int[] columnIndexes;
        private String[] columnNames;

        public CacheKey(String sql) {
            this.sql = sql;
        }

        public CacheKey(String sql, int autoGeneratedKeys) {
            this.sql = sql;
            this.autoGeneratedKeys = new Integer(autoGeneratedKeys);
        }

        public CacheKey(String sql, int resultSetType, int resultSetConcurrency) {
            this.sql = sql;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
        }

        public CacheKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
            this.sql = sql;
            this.resultSetType = resultSetType;
            this.resultSetConcurrency = resultSetConcurrency;
            this.resultSetHoldability = new Integer(resultSetHoldability);
        }

        public CacheKey(String sql, int[] columnIndexes) {
            this.sql = sql;
            this.columnIndexes = new int[columnIndexes.length];
            System.arraycopy(columnIndexes, 0, this.columnIndexes, 0, columnIndexes.length);
        }

        public CacheKey(String sql, String[] columnNames) {
            this.sql = sql;
            this.columnNames = new String[columnNames.length];
            System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey otherKey = (CacheKey)obj;
            if (!this.sql.equals(otherKey.sql)) {
                return false;
            }
            if (this.resultSetType != otherKey.resultSetType) {
                return false;
            }
            if (this.resultSetConcurrency != otherKey.resultSetConcurrency) {
                return false;
            }
            if (!Arrays.equals(this.columnIndexes, otherKey.columnIndexes)) {
                return false;
            }
            if (!Arrays.equals(this.columnNames, otherKey.columnNames)) {
                return false;
            }
            if (this.autoGeneratedKeys == null && otherKey.autoGeneratedKeys != null || this.autoGeneratedKeys != null && !this.autoGeneratedKeys.equals(otherKey.autoGeneratedKeys)) {
                return false;
            }
            return (this.resultSetHoldability != null || otherKey.resultSetHoldability == null) && (this.resultSetHoldability == null || this.resultSetHoldability.equals(otherKey.resultSetHoldability));
        }

        public int hashCode() {
            return this.sql != null ? this.sql.hashCode() : System.identityHashCode(this);
        }
    }
}

