/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.services.task.impl.model.ContentImpl;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.query.DeadlineSummaryImpl;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmJTATransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.commons.services.cdi.Startup;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskDeadlinesService;
import org.kie.internal.task.api.model.Escalation;
import org.kie.internal.task.api.model.InternalPeopleAssignments;
import org.kie.internal.task.api.model.InternalTaskData;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.NotificationEvent;
import org.kie.internal.task.api.model.NotificationType;
import org.kie.internal.task.api.model.Reassignment;

@Transactional
@ApplicationScoped
@Startup
public class TaskDeadlinesServiceImpl
implements TaskDeadlinesService {
    private ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(3);
    private Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> startScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
    private Map<Long, List<ScheduledFuture<ScheduledTaskDeadline>>> endScheduledTaskDeadlines = new ConcurrentHashMap<Long, List<ScheduledFuture<ScheduledTaskDeadline>>>();
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private TaskContentService taskContentService;
    @Inject
    private Event<NotificationEvent> notificationEvents;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void setNotificationEvents(Event<NotificationEvent> notificationEvents) {
        this.notificationEvents = notificationEvents;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setTaskContentService(TaskContentService taskContentService) {
        this.taskContentService = taskContentService;
    }

    @PostConstruct
    public void init() {
        long delay;
        if (!((JbpmServicesPersistenceManagerImpl)this.pm).hasTransactionManager()) {
            ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager((JbpmServicesTransactionManager)new JbpmJTATransactionManager());
        }
        long now = System.currentTimeMillis();
        List resultList = (List)this.pm.queryInTransaction("UnescalatedStartDeadlines");
        for (DeadlineSummaryImpl summary : resultList) {
            delay = summary.getDate().getTime() - now;
            this.schedule(summary.getTaskId(), summary.getDeadlineId(), delay, TaskDeadlinesService.DeadlineType.START);
        }
        resultList = (List)this.pm.queryInTransaction("UnescalatedEndDeadlines");
        for (DeadlineSummaryImpl summary : resultList) {
            delay = summary.getDate().getTime() - now;
            this.schedule(summary.getTaskId(), summary.getDeadlineId(), delay, TaskDeadlinesService.DeadlineType.END);
        }
    }

    private void executeEscalatedDeadline(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
        if (!((JbpmServicesPersistenceManagerImpl)this.pm).hasTransactionManager()) {
            ((JbpmServicesPersistenceManagerImpl)this.pm).setTransactionManager((JbpmServicesTransactionManager)new JbpmJTATransactionManager());
        }
        TaskImpl task = (TaskImpl)this.pm.find(TaskImpl.class, (Object)taskId);
        DeadlineImpl deadline = (DeadlineImpl)this.pm.find(DeadlineImpl.class, (Object)deadlineId);
        TaskData taskData = task.getTaskData();
        if (taskData != null && type.isValidStatus(taskData.getStatus())) {
            HashMap<String, Object> variables = null;
            ContentImpl content = (ContentImpl)this.pm.find(ContentImpl.class, (Object)taskData.getDocumentContentId());
            if (content != null) {
                ContentMarshallerContext context = this.taskContentService.getMarshallerContext((Task)task);
                Object objectFromBytes = ContentMarshallerHelper.unmarshall(content.getContent(), context.getEnvironment(), context.getClassloader());
                if (objectFromBytes instanceof Map) {
                    variables = (HashMap<String, Object>)objectFromBytes;
                } else {
                    variables = new HashMap<String, Object>();
                    variables.put("content", objectFromBytes);
                }
            } else {
                variables = Collections.emptyMap();
            }
            if (deadline == null || deadline.getEscalations() == null) {
                return;
            }
            for (Escalation escalation : deadline.getEscalations()) {
                if (!escalation.getReassignments().isEmpty()) {
                    Reassignment reassignment = (Reassignment)escalation.getReassignments().get(0);
                    ((InternalTaskData)task.getTaskData()).setStatus(Status.Ready);
                    ArrayList potentialOwners = new ArrayList(reassignment.getPotentialOwners());
                    ((InternalPeopleAssignments)task.getPeopleAssignments()).setPotentialOwners(potentialOwners);
                    ((InternalTaskData)task.getTaskData()).setActualOwner(null);
                }
                for (Notification notification : escalation.getNotifications()) {
                    if (notification.getNotificationType() != NotificationType.Email) continue;
                    this.logger.log(Level.INFO, " ### Sending an Email");
                    this.notificationEvents.fire((Object)new NotificationEvent(notification, (Task)task, variables));
                }
            }
        }
        deadline.setEscalated(true);
    }

    public void schedule(long taskId, long deadlineId, long delay, TaskDeadlinesService.DeadlineType type) {
        ScheduledFuture scheduled = this.scheduler.schedule(new ScheduledTaskDeadline(taskId, deadlineId, type), delay, TimeUnit.MILLISECONDS);
        List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
        if (type == TaskDeadlinesService.DeadlineType.START) {
            knownFutures = this.startScheduledTaskDeadlines.get(taskId);
        } else if (type == TaskDeadlinesService.DeadlineType.END) {
            knownFutures = this.endScheduledTaskDeadlines.get(taskId);
        }
        if (knownFutures == null) {
            knownFutures = new CopyOnWriteArrayList<ScheduledFuture<ScheduledTaskDeadline>>();
        }
        knownFutures.add(scheduled);
        if (type == TaskDeadlinesService.DeadlineType.START) {
            this.startScheduledTaskDeadlines.put(taskId, knownFutures);
        } else if (type == TaskDeadlinesService.DeadlineType.END) {
            this.endScheduledTaskDeadlines.put(taskId, knownFutures);
        }
    }

    public void unschedule(long taskId, TaskDeadlinesService.DeadlineType type) {
        List<ScheduledFuture<ScheduledTaskDeadline>> knownFutures = null;
        if (type == TaskDeadlinesService.DeadlineType.START) {
            knownFutures = this.startScheduledTaskDeadlines.get(taskId);
        } else if (type == TaskDeadlinesService.DeadlineType.END) {
            knownFutures = this.endScheduledTaskDeadlines.get(taskId);
        }
        if (knownFutures == null) {
            return;
        }
        for (ScheduledFuture<ScheduledTaskDeadline> scheduled : knownFutures) {
            try {
                if (scheduled.isDone() || scheduled.isCancelled()) continue;
                scheduled.cancel(true);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, " XXX :Error while cancelling scheduled deadline task for Task with id " + taskId + " -> " + e);
            }
        }
    }

    public class ScheduledTaskDeadline
    implements Callable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long taskId;
        private long deadlineId;
        private TaskDeadlinesService.DeadlineType type;

        public ScheduledTaskDeadline(long taskId, long deadlineId, TaskDeadlinesService.DeadlineType type) {
            this.taskId = taskId;
            this.deadlineId = deadlineId;
            this.type = type;
        }

        public long getTaskId() {
            return this.taskId;
        }

        public long getDeadlineId() {
            return this.deadlineId;
        }

        public TaskDeadlinesService.DeadlineType getType() {
            return this.type;
        }

        public Object call() throws Exception {
            TaskDeadlinesServiceImpl.this.executeEscalatedDeadline(this.taskId, this.deadlineId, this.type);
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.deadlineId ^ this.deadlineId >>> 32);
            result = 31 * result + (int)(this.taskId ^ this.taskId >>> 32);
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ScheduledTaskDeadline)) {
                return false;
            }
            ScheduledTaskDeadline other = (ScheduledTaskDeadline)obj;
            if (this.deadlineId != other.deadlineId) {
                return false;
            }
            if (this.taskId != other.taskId) {
                return false;
            }
            return !(this.type == null ? other.getType() != null : this.type.equals((Object)other.getType()));
        }
    }
}

