/**
 * Copyright 2010 Intalio Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jbpm.bpmn2.core;

import java.io.Serializable;

/**
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulme</a>
 */
public class Association implements Serializable {

	private static final long serialVersionUID = 4L;
	
	private String id;
	private String sourceRef;
	private String targetRef;
	private String direction = "none";
	
	public String getId() {
		return id;
	}
	
	public void setId(String id) {
		this.id = id;
	}
	
	public String getSourceRef() {
		return sourceRef;
	}
	
	public void setSourceRef(String sourceRef) {
		this.sourceRef = sourceRef;
	}
	
	public String getTargetRef() {
		return targetRef;
	}
	
	public void setTargetRef(String targetRef) {
		this.targetRef = targetRef;
	}

    public String getDirection() {
        return direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }
}
