/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.discard;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class DiscardServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(DiscardServerHandler.class.getName());
    private final AtomicLong transferredBytes = new AtomicLong();

    public long getTransferredBytes() {
        return this.transferredBytes.get();
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        this.transferredBytes.addAndGet(((ChannelBuffer)e.getMessage()).readableBytes());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

