/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.restlet;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.controller.restlet.ZKPropertyTransferServer;
import org.apache.helix.controller.restlet.ZNRecordUpdate;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;

public class ZNRecordUpdateResource
extends Resource {
    public static final String UPDATEKEY = "ZNRecordUpdate";
    private static Logger LOG = Logger.getLogger(ZNRecordUpdateResource.class);

    public boolean allowGet() {
        return false;
    }

    public boolean allowPost() {
        return false;
    }

    public boolean allowPut() {
        return true;
    }

    public boolean allowDelete() {
        return false;
    }

    public void storeRepresentation(Representation entity) {
        try {
            ZKPropertyTransferServer server = ZKPropertyTransferServer.getInstance();
            Form form = new Form(entity);
            String jsonPayload = form.getFirstValue(UPDATEKEY, true);
            StringReader sr = new StringReader(jsonPayload);
            ObjectMapper mapper = new ObjectMapper();
            TypeReference<TreeMap<String, ZNRecordUpdate>> typeRef = new TypeReference<TreeMap<String, ZNRecordUpdate>>(){};
            Map holderMap = (Map)mapper.readValue((Reader)sr, (TypeReference)typeRef);
            for (ZNRecordUpdate holder : holderMap.values()) {
                server.enqueueData(holder);
                LOG.info((Object)("Received " + holder.getPath() + " from " + this.getRequest().getClientInfo().getAddress()));
            }
            this.getResponse().setStatus(Status.SUCCESS_OK);
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
        }
    }
}

