/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.Arrays;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class DefaultParticipantErrorMessageHandlerFactory
implements MessageHandlerFactory {
    public static final String ACTIONKEY = "ActionOnError";
    private static Logger _logger = Logger.getLogger(DefaultParticipantErrorMessageHandlerFactory.class);
    final HelixManager _manager;

    public DefaultParticipantErrorMessageHandlerFactory(HelixManager manager) {
        this._manager = manager;
    }

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        String type = message.getMsgType();
        if (!type.equals(this.getMessageType())) {
            throw new HelixException("Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType());
        }
        return new DefaultParticipantErrorMessageHandler(message, context, this._manager);
    }

    @Override
    public String getMessageType() {
        return Message.MessageType.PARTICIPANT_ERROR_REPORT.toString();
    }

    @Override
    public void reset() {
    }

    public static class DefaultParticipantErrorMessageHandler
    extends MessageHandler {
        final HelixManager _manager;

        public DefaultParticipantErrorMessageHandler(Message message, NotificationContext context, HelixManager manager) {
            super(message, context);
            this._manager = manager;
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult result = new HelixTaskResult();
            result.setSuccess(true);
            try {
                ActionOnError actionOnError = ActionOnError.valueOf(this._message.getRecord().getSimpleField(DefaultParticipantErrorMessageHandlerFactory.ACTIONKEY));
                if (actionOnError == ActionOnError.DISABLE_INSTANCE) {
                    this._manager.getClusterManagmentTool().enableInstance(this._manager.getClusterName(), this._message.getMsgSrc(), false);
                    _logger.info((Object)("Instance " + this._message.getMsgSrc() + " disabled"));
                } else if (actionOnError == ActionOnError.DISABLE_PARTITION) {
                    this._manager.getClusterManagmentTool().enablePartition(false, this._manager.getClusterName(), this._message.getMsgSrc(), this._message.getResourceName(), Arrays.asList(this._message.getPartitionName()));
                    _logger.info((Object)("partition " + this._message.getPartitionName() + " disabled"));
                } else if (actionOnError == ActionOnError.DISABLE_RESOURCE) {
                    _logger.info((Object)("resource " + this._message.getResourceName() + " disabled"));
                }
            }
            catch (Exception e) {
                _logger.error((Object)"", (Throwable)e);
                result.setSuccess(false);
                result.setException(e);
            }
            return result;
        }

        @Override
        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            _logger.error((Object)("Message handling pipeline get an exception. MsgId:" + this._message.getMsgId()), (Throwable)e);
        }
    }

    public static enum ActionOnError {
        DISABLE_PARTITION,
        DISABLE_RESOURCE,
        DISABLE_INSTANCE;

    }
}

