/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import java.lang.management.ManagementFactory;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.controller.restlet.ZKPropertyTransferServer;
import org.apache.helix.model.LeaderHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.log4j.Logger;

public class DistClusterControllerElection
implements ControllerChangeListener {
    private static Logger LOG = Logger.getLogger(DistClusterControllerElection.class);
    private final String _zkAddr;
    private final GenericHelixController _controller = new GenericHelixController();
    private HelixManager _leader;

    public DistClusterControllerElection(String zkAddr) {
        this._zkAddr = zkAddr;
    }

    @Override
    public synchronized void onControllerChange(NotificationContext changeContext) {
        HelixManager manager = changeContext.getManager();
        if (manager == null) {
            LOG.error((Object)"missing attributes in changeContext. requires HelixManager");
            return;
        }
        InstanceType type = manager.getInstanceType();
        if (type != InstanceType.CONTROLLER && type != InstanceType.CONTROLLER_PARTICIPANT) {
            LOG.error((Object)("fail to become controller because incorrect instanceType (was " + type.toString() + ", requires CONTROLLER | CONTROLLER_PARTICIPANT)"));
            return;
        }
        try {
            if (changeContext.getType().equals((Object)NotificationContext.Type.INIT) || changeContext.getType().equals((Object)NotificationContext.Type.CALLBACK)) {
                HelixDataAccessor accessor = manager.getHelixDataAccessor();
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                while (accessor.getProperty(keyBuilder.controllerLeader()) == null) {
                    boolean success = this.tryUpdateController(manager);
                    if (!success) continue;
                    this.updateHistory(manager);
                    if (type == InstanceType.CONTROLLER) {
                        HelixControllerMain.addListenersToController(manager, this._controller);
                        manager.startTimerTasks();
                        continue;
                    }
                    if (type != InstanceType.CONTROLLER_PARTICIPANT) continue;
                    String clusterName = manager.getClusterName();
                    String controllerName = manager.getInstanceName();
                    this._leader = HelixManagerFactory.getZKHelixManager(clusterName, controllerName, InstanceType.CONTROLLER, this._zkAddr);
                    this._leader.connect();
                    this._leader.startTimerTasks();
                    HelixControllerMain.addListenersToController(this._leader, this._controller);
                }
            } else if (changeContext.getType().equals((Object)NotificationContext.Type.FINALIZE) && this._leader != null) {
                this._leader.disconnect();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception when trying to become leader", (Throwable)e);
        }
    }

    private boolean tryUpdateController(HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance leader = new LiveInstance(manager.getInstanceName());
        try {
            leader.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
            leader.setSessionId(manager.getSessionId());
            leader.setHelixVersion(manager.getVersion());
            if (ZKPropertyTransferServer.getInstance() != null) {
                String zkPropertyTransferServiceUrl = ZKPropertyTransferServer.getInstance().getWebserviceUrl();
                if (zkPropertyTransferServiceUrl != null) {
                    leader.setWebserviceUrl(zkPropertyTransferServiceUrl);
                }
            } else {
                LOG.warn((Object)"ZKPropertyTransferServer instnace is null");
            }
            boolean success = accessor.createProperty(keyBuilder.controllerLeader(), leader);
            if (success) {
                return true;
            }
            LOG.info((Object)"Unable to become leader probably because some other controller becames the leader");
        }
        catch (Exception e) {
            LOG.error((Object)("Exception when trying to updating leader record in cluster:" + manager.getClusterName() + ". Need to check again whether leader node has been created or not"), (Throwable)e);
        }
        leader = (LiveInstance)accessor.getProperty(keyBuilder.controllerLeader());
        if (leader != null) {
            String leaderSessionId = leader.getSessionId();
            LOG.info((Object)("Leader exists for cluster: " + manager.getClusterName() + ", currentLeader: " + leader.getInstanceName() + ", leaderSessionId: " + leaderSessionId));
            if (leaderSessionId != null && leaderSessionId.equals(manager.getSessionId())) {
                return true;
            }
        }
        return false;
    }

    private void updateHistory(HelixManager manager) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        LeaderHistory history = (LeaderHistory)accessor.getProperty((keyBuilder = accessor.keyBuilder()).controllerLeaderHistory());
        if (history == null) {
            history = new LeaderHistory(PropertyType.HISTORY.toString());
        }
        history.updateHistory(manager.getClusterName(), manager.getInstanceName());
        accessor.setProperty(keyBuilder.controllerLeaderHistory(), history);
    }
}

