/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jbpm.kie.services.api.DeploymentUnit;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.kie.services.api.Vfs;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.AbstractDeploymentService;
import org.jbpm.kie.services.impl.DeployedUnitImpl;
import org.jbpm.kie.services.impl.VFSDeploymentUnit;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.impl.model.ProcessDesc;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.runtime.manager.impl.cdi.InjectableRegisterableItemsFactory;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.kie.api.io.ResourceType;
import org.kie.commons.java.nio.file.Path;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Vfs
public class VFSDeploymentService
extends AbstractDeploymentService {
    private static final Logger logger = LoggerFactory.getLogger(VFSDeploymentService.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private FileService fs;
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private IdentityProvider identityProvider;
    @Inject
    private BPMN2DataService bpmn2Service;

    @Override
    public void deploy(DeploymentUnit unit) {
        super.deploy(unit);
        if (!(unit instanceof VFSDeploymentUnit)) {
            throw new IllegalArgumentException("Invalid deployment unit provided - " + unit.getClass().getName());
        }
        DeployedUnitImpl deployedUnit = new DeployedUnitImpl(unit);
        VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory(this.emf);
        AbstractAuditLogger auditLogger = AuditLoggerFactory.newJPAInstance((EntityManagerFactory)this.emf);
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider(this.identityProvider);
        auditEventBuilder.setDeploymentUnitId(vfsUnit.getIdentifier());
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        if (this.beanManager != null) {
            builder.registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
        }
        this.loadProcesses(vfsUnit, builder, deployedUnit);
        this.loadRules(vfsUnit, builder, deployedUnit);
        this.commonDeploy(vfsUnit, deployedUnit, builder.get());
    }

    protected void loadProcesses(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable loadProcessFiles = null;
        try {
            Path processFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadProcessFiles = this.fs.loadFilesByType(processFolder, ".+bpmn[2]?$");
        }
        catch (FileException ex) {
            logger.error("Error while loading process files", (Throwable)ex);
        }
        for (Path p : loadProcessFiles) {
            String processString = "";
            try {
                processString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])processString.getBytes()), ResourceType.BPMN2);
                ProcessDesc process = this.bpmn2Service.findProcessId(processString, null);
                process.setOriginalPath(p.toUri().toString());
                process.setDeploymentId(vfsUnit.getIdentifier());
                deployedUnit.addAssetLocation(process.getId(), process);
            }
            catch (Exception ex) {
                logger.error("Error while reading process files", (Throwable)ex);
            }
        }
    }

    protected void loadRules(VFSDeploymentUnit vfsUnit, RuntimeEnvironmentBuilder builder, DeployedUnitImpl deployedUnit) {
        Iterable loadRuleFiles = null;
        try {
            Path rulesFolder = this.fs.getPath(vfsUnit.getRepository() + vfsUnit.getRepositoryFolder());
            loadRuleFiles = this.fs.loadFilesByType(rulesFolder, ".+drl");
        }
        catch (FileException ex) {
            logger.error("Error while loading rule files", (Throwable)ex);
        }
        for (Path p : loadRuleFiles) {
            String ruleString = "";
            try {
                ruleString = new String(this.fs.loadFile(p));
                builder.addAsset(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL);
            }
            catch (Exception ex) {
                logger.error("Error while reading rule files", (Throwable)ex);
            }
        }
    }

    public JbpmServicesPersistenceManager getPm() {
        return this.pm;
    }

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public FileService getFs() {
        return this.fs;
    }

    public void setFs(FileService fs) {
        this.fs = fs;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public IdentityProvider getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(IdentityProvider identityProvider) {
        this.identityProvider = identityProvider;
    }

    public BPMN2DataService getBpmn2Service() {
        return this.bpmn2Service;
    }

    public void setBpmn2Service(BPMN2DataService bpmn2Service) {
        this.bpmn2Service = bpmn2Service;
    }
}

