/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.resource.common.AbstractXAStatefulHolder;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceHolderStateVisitor;
import bitronix.tm.utils.Uid;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXAResourceHolder
extends AbstractXAStatefulHolder
implements XAResourceHolder {
    private static final Logger log = LoggerFactory.getLogger(AbstractXAResourceHolder.class);
    private final Map<Uid, Map<Uid, XAResourceHolderState>> xaResourceHolderStates = new HashMap<Uid, Map<Uid, XAResourceHolderState>>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Uid, XAResourceHolderState> getXAResourceHolderStatesForGtrid(Uid gtrid) {
        this.rwLock.readLock().lock();
        try {
            Map<Uid, XAResourceHolderState> map = this.xaResourceHolderStates.get(gtrid);
            Object var4_3 = null;
            this.rwLock.readLock().unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistXAResourceHolderStatesForGtrid(Uid gtrid) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.xaResourceHolderStates.containsKey(gtrid);
            Object var4_3 = null;
            this.rwLock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getXAResourceHolderStateCountForGtrid(Uid gtrid) {
        block3: {
            this.rwLock.readLock().lock();
            try {
                Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
                if (statesForGtrid == null) break block3;
                int n = statesForGtrid.size();
                Object var5_5 = null;
                this.rwLock.readLock().unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.rwLock.readLock().unlock();
                throw throwable;
            }
        }
        int n = 0;
        Object var5_6 = null;
        this.rwLock.readLock().unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptVisitorForXAResourceHolderStates(Uid gtrid, XAResourceHolderStateVisitor visitor) {
        this.rwLock.readLock().lock();
        try {
            Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
            if (statesForGtrid != null) {
                for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                    if (!visitor.visit(xaResourceHolderState)) break;
                }
            }
            Object var7_6 = null;
            this.rwLock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putXAResourceHolderState(BitronixXid xid, XAResourceHolderState xaResourceHolderState) {
        Uid gtrid = xid.getGlobalTransactionIdUid();
        Uid bqual = xid.getBranchQualifierUid();
        this.rwLock.writeLock().lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("putting XAResourceHolderState [" + xaResourceHolderState + "] on " + this);
            }
            if (!this.xaResourceHolderStates.containsKey(gtrid)) {
                if (log.isDebugEnabled()) {
                    log.debug("GTRID [" + gtrid + "] previously unknown to " + this + ", adding it to the resource's transactions list");
                }
                LinkedHashMap<Uid, XAResourceHolderState> statesForGtrid = new LinkedHashMap<Uid, XAResourceHolderState>(4);
                statesForGtrid.put(bqual, xaResourceHolderState);
                this.xaResourceHolderStates.put(gtrid, statesForGtrid);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("GTRID [" + gtrid + "] previously known to " + this + ", adding it to the resource's transactions list");
                }
                Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
                statesForGtrid.put(bqual, xaResourceHolderState);
            }
            Object var7_7 = null;
            this.rwLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.rwLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeXAResourceHolderState(BitronixXid xid) {
        block7: {
            block6: {
                Uid gtrid = xid.getGlobalTransactionIdUid();
                Uid bqual = xid.getBranchQualifierUid();
                this.rwLock.writeLock().lock();
                try {
                    Map<Uid, XAResourceHolderState> statesForGtrid;
                    if (log.isDebugEnabled()) {
                        log.debug("removing XAResourceHolderState of xid " + xid + " from " + this);
                    }
                    if ((statesForGtrid = this.xaResourceHolderStates.get(gtrid)) == null) {
                        log.warn("tried to remove unknown GTRID [" + gtrid + "] from " + this + " - Bug?");
                        Object var7_5 = null;
                        this.rwLock.writeLock().unlock();
                        return;
                    }
                    XAResourceHolderState removed = statesForGtrid.remove(bqual);
                    if (removed == null) {
                        log.warn("tried to remove unknown BQUAL [" + bqual + "] from " + this + " - Bug?");
                        break block6;
                    }
                    if (statesForGtrid.isEmpty()) {
                        this.xaResourceHolderStates.remove(gtrid);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.rwLock.writeLock().unlock();
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.rwLock.writeLock().unlock();
            return;
        }
        Object var7_7 = null;
        this.rwLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasStateForXAResource(XAResourceHolder xaResourceHolder) {
        boolean bl;
        this.rwLock.readLock().lock();
        try {
            for (Map<Uid, XAResourceHolderState> statesForGtrid : this.xaResourceHolderStates.values()) {
                for (XAResourceHolderState otherXaResourceHolderState : statesForGtrid.values()) {
                    if (otherXaResourceHolderState.getXAResource() != xaResourceHolder.getXAResource()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("resource " + xaResourceHolder + " is enlisted in another transaction with " + otherXaResourceHolderState.getXid().toString());
                    }
                    boolean bl2 = true;
                    Object var8_8 = null;
                    this.rwLock.readLock().unlock();
                    return bl2;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("resource not enlisted in any transaction: " + xaResourceHolder);
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
        Object var8_9 = null;
        this.rwLock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isParticipatingInActiveGlobalTransaction() {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                boolean bl3;
                block5: {
                    this.rwLock.readLock().lock();
                    try {
                        Uid gtrid;
                        BitronixTransaction currentTransaction = TransactionContextHelper.currentTransaction();
                        Uid uid = gtrid = currentTransaction == null ? null : currentTransaction.getResourceManager().getGtrid();
                        if (gtrid == null) {
                            boolean bl4 = false;
                            Object var8_5 = null;
                            this.rwLock.readLock().unlock();
                            return bl4;
                        }
                        Map<Uid, XAResourceHolderState> statesForGtrid = this.xaResourceHolderStates.get(gtrid);
                        if (statesForGtrid == null) {
                            bl3 = false;
                            break block5;
                        }
                        for (XAResourceHolderState xaResourceHolderState : statesForGtrid.values()) {
                            if (xaResourceHolderState == null || !xaResourceHolderState.isStarted() || xaResourceHolderState.isSuspended() || xaResourceHolderState.isEnded()) continue;
                            bl2 = true;
                            break block6;
                        }
                        bl = false;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        this.rwLock.readLock().unlock();
                        throw throwable;
                    }
                }
                Object var8_6 = null;
                this.rwLock.readLock().unlock();
                return bl3;
            }
            Object var8_7 = null;
            this.rwLock.readLock().unlock();
            return bl2;
        }
        Object var8_8 = null;
        this.rwLock.readLock().unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getXAResourceHolderStateGtrids() {
        this.rwLock.readLock().lock();
        try {
            HashSet<String> gtridsAsStrings = new HashSet<String>();
            for (Uid uid : this.xaResourceHolderStates.keySet()) {
                gtridsAsStrings.add(uid.toString());
            }
            HashSet<String> hashSet = gtridsAsStrings;
            Object var5_4 = null;
            this.rwLock.readLock().unlock();
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.rwLock.readLock().unlock();
            throw throwable;
        }
    }
}

