/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.IncrementalRecoverer;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAFactoryHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceHolderStateVisitor;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Uid;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAPool
implements StateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(XAPool.class);
    private final ReentrantReadWriteLock stateTransitionLock = new ReentrantReadWriteLock();
    private final BlockingQueue<XAStatefulHolder> availablePool = new LinkedBlockingQueue<XAStatefulHolder>();
    private final Queue<XAStatefulHolder> accessiblePool = new LinkedList<XAStatefulHolder>();
    private final Queue<XAStatefulHolder> inaccessiblePool = new LinkedList<XAStatefulHolder>();
    private final AtomicInteger poolSize = new AtomicInteger();
    private final Map<Uid, StatefulHolderThreadLocal> statefulHolderTransactionMap = new ConcurrentHashMap<Uid, StatefulHolderThreadLocal>();
    private final ResourceBean bean;
    private final XAResourceProducer xaResourceProducer;
    private final Object xaFactory;
    private final AtomicBoolean failed = new AtomicBoolean();
    private final Object poolGrowthShrinkLock = new Object();

    public XAPool(XAResourceProducer xaResourceProducer, ResourceBean bean, Object xaFactory) throws Exception {
        this.xaResourceProducer = xaResourceProducer;
        this.bean = bean;
        if (bean.getMaxPoolSize() < 1 || bean.getMinPoolSize() > bean.getMaxPoolSize()) {
            throw new IllegalArgumentException("cannot create a pool with min " + bean.getMinPoolSize() + " connection(s) and max " + bean.getMaxPoolSize() + " connection(s)");
        }
        if (bean.getAcquireIncrement() < 1) {
            throw new IllegalArgumentException("cannot create a pool with a connection acquisition increment less than 1, configured value is " + bean.getAcquireIncrement());
        }
        this.xaFactory = xaFactory == null ? XAFactoryHelper.createXAFactory(bean) : xaFactory;
        this.init();
        if (bean.getIgnoreRecoveryFailures()) {
            log.warn("resource '" + bean.getUniqueName() + "' is configured to ignore recovery failures, make sure this setting is not enabled on a production system!");
        }
    }

    private void init() throws Exception {
        this.growUntilMinPoolSize();
        if (this.bean.getMaxIdleTime() > 0 || this.bean.getMaxLifeTime() > 0) {
            TransactionManagerServices.getTaskScheduler().schedulePoolShrinking(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug("closing all connections of " + this);
            }
            for (XAStatefulHolder xaStatefulHolder : this.getXAResourceHolders()) {
                try {
                    xaStatefulHolder.close();
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("ignoring exception while closing connection " + xaStatefulHolder, (Throwable)ex);
                }
            }
            if (TransactionManagerServices.isTaskSchedulerRunning()) {
                TransactionManagerServices.getTaskScheduler().cancelPoolShrinking(this);
            }
            this.stateTransitionLock.writeLock().lock();
            try {
                this.availablePool.clear();
                this.accessiblePool.clear();
                this.inaccessiblePool.clear();
                this.failed.set(false);
            }
            finally {
                this.stateTransitionLock.writeLock().unlock();
            }
        }
    }

    public Object getConnectionHandle() throws Exception {
        return this.getConnectionHandle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object getConnectionHandle(boolean recycle) throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (this.isFailed()) {
                this.reinitializePool();
            }
        }
        long remainingTimeMs = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionTimeout());
        while (true) {
            long before = MonotonicClock.currentTimeMillis();
            XAStatefulHolder xaStatefulHolder = null;
            if (recycle) {
                xaStatefulHolder = this.bean.getShareTransactionConnections() ? this.getSharedXAStatefulHolder() : this.getNotAccessible();
            }
            if (xaStatefulHolder == null) {
                xaStatefulHolder = this.getInPool(remainingTimeMs);
            }
            if (log.isDebugEnabled()) {
                log.debug("found " + Decoder.decodeXAStatefulHolderState(xaStatefulHolder.getState()) + " connection " + xaStatefulHolder + " from " + this);
            }
            try {
                Object connectionHandle = xaStatefulHolder.getConnectionHandle();
                if (this.bean.getShareTransactionConnections()) {
                    this.putSharedXAStatefulHolder(xaStatefulHolder);
                }
                return connectionHandle;
            }
            catch (Exception ex) {
                block33: {
                    InterruptedException ex22222;
                    long waitTime;
                    Object var10_11;
                    if (log.isDebugEnabled()) {
                        log.debug("connection is invalid, trying to close it", (Throwable)ex);
                    }
                    try {
                        xaStatefulHolder.close();
                        var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        if (log.isDebugEnabled()) {
                            log.debug("removed invalid connection " + xaStatefulHolder + " from " + this);
                        }
                        if (xaStatefulHolder.getState() != 0) {
                            this.stateChanged(xaStatefulHolder, xaStatefulHolder.getState(), 0);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("waiting " + this.bean.getAcquisitionInterval() + "s before trying to acquire a connection again from " + this);
                        }
                        if ((waitTime = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionInterval())) > 0L) {
                            try {
                                Thread.sleep(waitTime);
                            }
                            catch (InterruptedException ex22222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("removed invalid connection " + xaStatefulHolder + " from " + this);
                    }
                    if (xaStatefulHolder.getState() != 0) {
                        this.stateChanged(xaStatefulHolder, xaStatefulHolder.getState(), 0);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("waiting " + this.bean.getAcquisitionInterval() + "s before trying to acquire a connection again from " + this);
                    }
                    if ((waitTime = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionInterval())) > 0L) {
                        try {
                            Thread.sleep(waitTime);
                        }
                        catch (InterruptedException ex22222) {}
                    }
                    break block33;
                    {
                        catch (Exception ex23) {
                            if (log.isDebugEnabled()) {
                                log.debug("exception while trying to close invalid connection, ignoring it", (Throwable)ex23);
                            }
                            var10_11 = null;
                            if (log.isDebugEnabled()) {
                                log.debug("removed invalid connection " + xaStatefulHolder + " from " + this);
                            }
                            if (xaStatefulHolder.getState() != 0) {
                                this.stateChanged(xaStatefulHolder, xaStatefulHolder.getState(), 0);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("waiting " + this.bean.getAcquisitionInterval() + "s before trying to acquire a connection again from " + this);
                            }
                            if ((waitTime = TimeUnit.SECONDS.toMillis(this.bean.getAcquisitionInterval())) > 0L) {
                                try {
                                    Thread.sleep(waitTime);
                                }
                                catch (InterruptedException ex22222) {}
                            }
                        }
                    }
                }
                long now = MonotonicClock.currentTimeMillis();
                remainingTimeMs -= now - before;
                before = now;
                if (remainingTimeMs > 0L) continue;
                throw new BitronixRuntimeException("cannot get valid connection from " + this + " after trying for " + this.bean.getAcquisitionTimeout() + "s", ex);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanging(XAStatefulHolder source, int currentState, int futureState) {
        this.stateTransitionLock.writeLock().lock();
        try {
            switch (currentState) {
                case 1: {
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug("removed " + source + " from the accessible pool");
                    }
                    this.accessiblePool.remove(source);
                    break;
                }
                case 3: {
                    if (log.isDebugEnabled()) {
                        log.debug("removed " + source + " from the inaccessible pool");
                    }
                    this.inaccessiblePool.remove(source);
                    break;
                }
            }
            Object var5_4 = null;
            this.stateTransitionLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stateTransitionLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(XAStatefulHolder source, int oldState, int newState) {
        this.stateTransitionLock.writeLock().lock();
        try {
            switch (newState) {
                case 1: {
                    if (log.isDebugEnabled()) {
                        log.debug("added " + source + " to the available pool");
                    }
                    this.availablePool.add(source);
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug("added " + source + " to the accessible pool");
                    }
                    this.accessiblePool.add(source);
                    break;
                }
                case 3: {
                    if (log.isDebugEnabled()) {
                        log.debug("added " + source + " to the inaccessible pool");
                    }
                    this.inaccessiblePool.add(source);
                    break;
                }
                case 0: {
                    source.removeStateChangeEventListener(this);
                    this.poolSize.decrementAndGet();
                }
            }
            Object var5_4 = null;
            this.stateTransitionLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.stateTransitionLock.writeLock().unlock();
            throw throwable;
        }
    }

    private XAStatefulHolder getInPool(long remainingTimeMs) throws Exception {
        if (this.inPoolSize() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("no more free connections in " + this + ", trying to grow it");
            }
            this.grow();
        }
        if (log.isDebugEnabled()) {
            log.debug("getting IN_POOL connection from " + this + ", waiting if necessary");
        }
        try {
            XAStatefulHolder xaStatefulHolder = this.availablePool.poll(remainingTimeMs, TimeUnit.MILLISECONDS);
            if (xaStatefulHolder == null) {
                if (TransactionManagerServices.isTransactionManagerRunning()) {
                    TransactionManagerServices.getTransactionManager().dumpTransactionContexts();
                }
                throw new BitronixRuntimeException("XA pool of resource " + this.bean.getUniqueName() + " still empty after " + this.bean.getAcquisitionTimeout() + "s wait time");
            }
            if (this.expireStatefulHolder(xaStatefulHolder, false)) {
                return this.getInPool(remainingTimeMs);
            }
            return xaStatefulHolder;
        }
        catch (InterruptedException e) {
            throw new BitronixRuntimeException("Interrupted while waiting for IN_POOL connection.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XAStatefulHolder getNotAccessible() {
        XAStatefulHolder xAStatefulHolder;
        BitronixTransaction transaction;
        if (log.isDebugEnabled()) {
            log.debug("trying to recycle a NOT_ACCESSIBLE connection of " + this);
        }
        if ((transaction = TransactionContextHelper.currentTransaction()) == null) {
            if (!log.isDebugEnabled()) return null;
            log.debug("no current transaction, no connection can be in state NOT_ACCESSIBLE when there is no global transaction context");
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        if (log.isDebugEnabled()) {
            log.debug("current transaction GTRID is [" + currentTxGtrid + "]");
        }
        this.stateTransitionLock.readLock().lock();
        try {
            for (XAStatefulHolder xaStatefulHolder : this.inaccessiblePool) {
                if (log.isDebugEnabled()) {
                    log.debug("found a connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
                }
                if (!this.containsXAResourceHolderMatchingGtrid(xaStatefulHolder, currentTxGtrid)) continue;
                XAStatefulHolder xAStatefulHolder2 = xaStatefulHolder;
                Object var7_6 = null;
                this.stateTransitionLock.readLock().unlock();
                return xAStatefulHolder2;
            }
            if (log.isDebugEnabled()) {
                log.debug("no NOT_ACCESSIBLE connection enlisted in this transaction");
            }
            xAStatefulHolder = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.stateTransitionLock.readLock().unlock();
            throw throwable;
        }
        Object var7_7 = null;
        this.stateTransitionLock.readLock().unlock();
        return xAStatefulHolder;
    }

    private XAStatefulHolder getSharedXAStatefulHolder() {
        XAStatefulHolder xaStatefulHolder;
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (log.isDebugEnabled()) {
                log.debug("no current transaction, shared connection map will not be used");
            }
            return null;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        StatefulHolderThreadLocal threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal != null && (xaStatefulHolder = threadLocal.get()) != null && xaStatefulHolder.getState() != 1 && xaStatefulHolder.getState() != 0) {
            if (log.isDebugEnabled()) {
                log.debug("sharing connection " + xaStatefulHolder + " in transaction " + currentTxGtrid);
            }
            return xaStatefulHolder;
        }
        return null;
    }

    private boolean containsXAResourceHolderMatchingGtrid(XAStatefulHolder xaStatefulHolder, final Uid currentTxGtrid) {
        List<XAResourceHolder> xaResourceHolders = xaStatefulHolder.getXAResourceHolders();
        if (log.isDebugEnabled()) {
            log.debug(xaResourceHolders.size() + " xa resource(s) created by connection in NOT_ACCESSIBLE state: " + xaStatefulHolder);
        }
        for (XAResourceHolder xaResourceHolder : xaResourceHolders) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LocalVisitor
            implements XAResourceHolderStateVisitor {
                private boolean found;

                LocalVisitor() {
                }

                @Override
                public boolean visit(XAResourceHolderState xaResourceHolderState) {
                    BitronixXid bitronixXid = xaResourceHolderState.getXid();
                    Uid resourceGtrid = bitronixXid.getGlobalTransactionIdUid();
                    if (log.isDebugEnabled()) {
                        log.debug("NOT_ACCESSIBLE xa resource GTRID: " + resourceGtrid);
                    }
                    if (currentTxGtrid.equals(resourceGtrid)) {
                        if (log.isDebugEnabled()) {
                            log.debug("NOT_ACCESSIBLE xa resource's GTRID matched this transaction's GTRID, recycling it");
                        }
                        this.found = true;
                    }
                    return !this.found;
                }
            }
            LocalVisitor xaResourceHolderStateVisitor = new LocalVisitor();
            xaResourceHolder.acceptVisitorForXAResourceHolderStates(currentTxGtrid, xaResourceHolderStateVisitor);
            if (!xaResourceHolderStateVisitor.found) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grow() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            long totalPoolSize = this.totalPoolSize();
            if (totalPoolSize < (long)this.bean.getMaxPoolSize()) {
                long increment = this.bean.getAcquireIncrement();
                if (totalPoolSize + increment > (long)this.bean.getMaxPoolSize()) {
                    increment = (long)this.bean.getMaxPoolSize() - totalPoolSize;
                }
                if (log.isDebugEnabled()) {
                    log.debug("incrementing " + this.bean.getUniqueName() + " pool size by " + increment + " unit(s) to reach " + ((long)this.totalPoolSize() + increment) + " connection(s)");
                }
                int i = 0;
                while ((long)i < increment) {
                    this.createPooledObject(this.xaFactory);
                    ++i;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("pool " + this.bean.getUniqueName() + " already at max size of " + this.totalPoolSize() + " connection(s), not growing it");
            }
            if (this.totalPoolSize() < this.bean.getMinPoolSize()) {
                this.growUntilMinPoolSize();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growUntilMinPoolSize() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug("growing " + this + " to minimum pool size " + this.bean.getMinPoolSize());
            }
            for (int i = this.totalPoolSize(); i < this.bean.getMinPoolSize(); ++i) {
                this.createPooledObject(this.xaFactory);
            }
        }
    }

    private void createPooledObject(Object xaFactory) throws Exception {
        XAStatefulHolder xaStatefulHolder = this.xaResourceProducer.createPooledConnection(xaFactory, this.bean);
        xaStatefulHolder.addStateChangeEventListener(this);
        this.availablePool.add(xaStatefulHolder);
        this.poolSize.incrementAndGet();
    }

    public Date getNextShrinkDate() {
        return new Date(MonotonicClock.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.bean.getMaxIdleTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shrink() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug("shrinking " + this);
            }
            this.expireOrCloseStatefulHolders(false);
            if (log.isDebugEnabled()) {
                log.debug("shrunk " + this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws Exception {
        Object object = this.poolGrowthShrinkLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug("resetting " + this);
            }
            this.expireOrCloseStatefulHolders(true);
            if (log.isDebugEnabled()) {
                log.debug("reset " + this);
            }
        }
    }

    private void expireOrCloseStatefulHolders(boolean forceClose) throws Exception {
        XAStatefulHolder xaStatefulHolder;
        int closed = 0;
        int availableSize = this.availablePool.size();
        for (int i = 0; i < availableSize && (xaStatefulHolder = (XAStatefulHolder)this.availablePool.poll()) != null; ++i) {
            if (this.expireStatefulHolder(xaStatefulHolder, forceClose)) {
                ++closed;
                continue;
            }
            this.availablePool.add(xaStatefulHolder);
        }
        if (log.isDebugEnabled()) {
            log.debug("closed " + closed + (forceClose ? " " : " idle ") + "connection(s)");
        }
        this.growUntilMinPoolSize();
    }

    private boolean expireStatefulHolder(XAStatefulHolder xaStatefulHolder, boolean forceClose) {
        long expirationTime = Long.MAX_VALUE;
        if (this.bean.getMaxIdleTime() > 0) {
            expirationTime = xaStatefulHolder.getLastReleaseDate().getTime() + TimeUnit.SECONDS.toMillis(this.bean.getMaxIdleTime());
        }
        if (this.bean.getMaxLifeTime() > 0) {
            long endOfLife = xaStatefulHolder.getCreationDate().getTime() + TimeUnit.SECONDS.toMillis(this.bean.getMaxLifeTime());
            expirationTime = Math.min(expirationTime, endOfLife);
        }
        long now = MonotonicClock.currentTimeMillis();
        if (!forceClose && log.isDebugEnabled()) {
            log.debug("checking if connection can be closed: " + xaStatefulHolder + " - closing time: " + expirationTime + ", now time: " + now);
        }
        if (expirationTime <= now || forceClose) {
            try {
                xaStatefulHolder.close();
            }
            catch (Exception ex) {
                log.warn("error closing " + xaStatefulHolder, (Throwable)ex);
            }
            return true;
        }
        return false;
    }

    private void reinitializePool() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("resource '" + this.bean.getUniqueName() + "' is marked as failed, resetting and recovering it before trying connection acquisition");
            }
            this.close();
            this.init();
            IncrementalRecoverer.recover(this.xaResourceProducer);
        }
        catch (RecoveryException ex) {
            throw new BitronixRuntimeException("incremental recovery failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
        }
        catch (Exception ex) {
            throw new BitronixRuntimeException("pool reset failed when trying to acquire a connection from failed resource '" + this.bean.getUniqueName() + "'", ex);
        }
    }

    public Object getXAFactory() {
        return this.xaFactory;
    }

    public void setFailed(boolean failed) {
        this.failed.set(failed);
    }

    public boolean isFailed() {
        return this.failed.get();
    }

    public int totalPoolSize() {
        return this.poolSize.get();
    }

    public int inPoolSize() {
        return this.availablePool.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XAStatefulHolder> getXAResourceHolders() {
        this.stateTransitionLock.readLock().lock();
        try {
            ArrayList<XAStatefulHolder> holders = new ArrayList<XAStatefulHolder>();
            holders.addAll(this.availablePool);
            holders.addAll(this.accessiblePool);
            holders.addAll(this.inaccessiblePool);
            ArrayList<XAStatefulHolder> arrayList = holders;
            Object var4_3 = null;
            this.stateTransitionLock.readLock().unlock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.stateTransitionLock.readLock().unlock();
            throw throwable;
        }
    }

    public String toString() {
        return "an XAPool of resource " + this.bean.getUniqueName() + " with " + this.totalPoolSize() + " connection(s) (" + this.inPoolSize() + " still available)" + (this.isFailed() ? " -failed-" : "");
    }

    private void putSharedXAStatefulHolder(XAStatefulHolder xaStatefulHolder) {
        BitronixTransaction transaction = TransactionContextHelper.currentTransaction();
        if (transaction == null) {
            if (log.isDebugEnabled()) {
                log.debug("no current transaction, not adding " + xaStatefulHolder + " to shared connection map");
            }
            return;
        }
        Uid currentTxGtrid = transaction.getResourceManager().getGtrid();
        StatefulHolderThreadLocal threadLocal = this.statefulHolderTransactionMap.get(currentTxGtrid);
        if (threadLocal == null) {
            try {
                transaction.registerSynchronization(new SharedStatefulHolderCleanupSynchronization(currentTxGtrid));
            }
            catch (Exception e) {
                return;
            }
            threadLocal = new StatefulHolderThreadLocal();
            this.statefulHolderTransactionMap.put(currentTxGtrid, threadLocal);
            if (log.isDebugEnabled()) {
                log.debug("added shared connection mapping for " + currentTxGtrid + " holder " + xaStatefulHolder);
            }
        }
        threadLocal.set(xaStatefulHolder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatefulHolderThreadLocal
    extends ThreadLocal<XAStatefulHolder> {
        private StatefulHolderThreadLocal() {
        }

        @Override
        public XAStatefulHolder get() {
            return (XAStatefulHolder)super.get();
        }

        @Override
        public void set(XAStatefulHolder value) {
            super.set(value);
        }
    }

    private final class SharedStatefulHolderCleanupSynchronization
    implements Synchronization {
        private final Uid gtrid;

        private SharedStatefulHolderCleanupSynchronization(Uid gtrid) {
            this.gtrid = gtrid;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            XAPool.this.statefulHolderTransactionMap.remove(this.gtrid);
            if (log.isDebugEnabled()) {
                log.debug("deleted shared connection mappings for " + this.gtrid);
            }
        }

        public String toString() {
            return "a SharedStatefulHolderCleanupSynchronization with GTRID [" + this.gtrid + "]";
        }
    }
}

