/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.PooledConnectionProxy;
import bitronix.tm.resource.jdbc.proxy.JavaProxyBase;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionJavaProxy
extends JavaProxyBase<Connection>
implements PooledConnectionProxy {
    private static final Logger log = LoggerFactory.getLogger(ConnectionJavaProxy.class);
    private static final Map<String, Method> selfMethodMap = ConnectionJavaProxy.createMethodMap(ConnectionJavaProxy.class);
    private JdbcPooledConnection jdbcPooledConnection;
    private boolean useStatementCache;

    public ConnectionJavaProxy() {
    }

    public ConnectionJavaProxy(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        this.initialize(jdbcPooledConnection, connection);
    }

    void initialize(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        this.proxy = this;
        this.jdbcPooledConnection = jdbcPooledConnection;
        this.delegate = connection;
        if (jdbcPooledConnection != null) {
            this.useStatementCache = jdbcPooledConnection.getPoolingDataSource().getPreparedStatementCacheSize() > 0;
        }
    }

    public String toString() {
        return "a ConnectionJavaProxy of " + this.jdbcPooledConnection + " on " + this.delegate;
    }

    @Override
    public JdbcPooledConnection getPooledConnection() {
        return this.jdbcPooledConnection;
    }

    @Override
    public Connection getProxiedDelegate() {
        return (Connection)this.delegate;
    }

    public void close() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("closing " + this);
        }
        if (this.jdbcPooledConnection == null) {
            return;
        }
        this.jdbcPooledConnection.release();
        this.jdbcPooledConnection = null;
    }

    public void commit() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot commit a resource enlisted in a global transaction");
        }
        ((Connection)this.delegate).commit();
    }

    public void rollback() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot rollback a resource enlisted in a global transaction");
        }
        ((Connection)this.delegate).rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot rollback a resource enlisted in a global transaction");
        }
        ((Connection)this.delegate).rollback(savepoint);
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot set a savepoint on a resource enlisted in a global transaction");
        }
        return ((Connection)this.delegate).setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot set a savepoint on a resource enlisted in a global transaction");
        }
        return ((Connection)this.delegate).setSavepoint(name);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            throw new SQLException("cannot release a savepoint on a resource enlisted in a global transaction");
        }
        ((Connection)this.delegate).releaseSavepoint(savepoint);
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            return false;
        }
        return ((Connection)this.delegate).getAutoCommit();
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (!this.jdbcPooledConnection.isParticipatingInActiveGlobalTransaction()) {
            ((Connection)this.delegate).setAutoCommit(autoCommit);
        } else if (autoCommit) {
            throw new SQLException("autocommit is not allowed on a resource enlisted in a global transaction");
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            return true;
        }
        return ((Connection)this.delegate).isClosed();
    }

    public Statement createStatement() throws SQLException {
        this.enlistResource();
        Statement statement = ((Connection)this.delegate).createStatement();
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        Statement statementProxy = JdbcProxyFactory.INSTANCE.getProxyStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.enlistResource();
        Statement statement = ((Connection)this.delegate).createStatement(resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        Statement statementProxy = JdbcProxyFactory.INSTANCE.getProxyStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.enlistResource();
        Statement statement = ((Connection)this.delegate).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        Statement statementProxy = JdbcProxyFactory.INSTANCE.getProxyStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.enlistResource();
        CallableStatement statement = ((Connection)this.delegate).prepareCall(sql);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        CallableStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyCallableStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.enlistResource();
        CallableStatement statement = ((Connection)this.delegate).prepareCall(sql, resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        CallableStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyCallableStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.enlistResource();
        CallableStatement statement = ((Connection)this.delegate).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(statement);
        CallableStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyCallableStatement(this.jdbcPooledConnection, statement);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql, autoGeneratedKeys);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, autoGeneratedKeys);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, autoGeneratedKeys);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql, resultSetType, resultSetConcurrency);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql, columnIndexes);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, columnIndexes);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, columnIndexes);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.enlistResource();
        if (this.useStatementCache) {
            LruStatementCache.CacheKey cacheKey = new LruStatementCache.CacheKey(sql, columnNames);
            PreparedStatement cachedStmt = this.jdbcPooledConnection.getCachedStatement(cacheKey);
            if (cachedStmt == null) {
                PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, columnNames);
                cachedStmt = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, cacheKey);
                this.jdbcPooledConnection.putCachedStatement(cacheKey, cachedStmt);
            }
            return cachedStmt;
        }
        PreparedStatement stmt = ((Connection)this.delegate).prepareStatement(sql, columnNames);
        this.jdbcPooledConnection.registerUncachedStatement(stmt);
        PreparedStatement statementProxy = JdbcProxyFactory.INSTANCE.getProxyPreparedStatement(this.jdbcPooledConnection, stmt, null);
        return statementProxy;
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(((Connection)this.delegate).getClass()) || ConnectionJavaProxy.isWrapperFor(this.delegate, iface);
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(((Connection)this.delegate).getClass())) {
            return (T)this.delegate;
        }
        if (this.isWrapperFor(iface)) {
            return ConnectionJavaProxy.unwrap(this.delegate, iface);
        }
        throw new SQLException(this.getClass().getName() + " is not a wrapper for " + iface);
    }

    private void enlistResource() throws SQLException {
        if (this.jdbcPooledConnection == null) {
            throw new SQLException("connection handle already closed");
        }
        if (this.jdbcPooledConnection.getPoolingDataSource().getAutomaticEnlistingEnabled()) {
            try {
                TransactionContextHelper.enlistInCurrentTransaction(this.jdbcPooledConnection);
            }
            catch (SystemException ex) {
                throw (SQLException)new SQLException("error enlisting " + this).initCause(ex);
            }
            catch (RollbackException ex) {
                throw (SQLException)new SQLException("error enlisting " + this).initCause(ex);
            }
        }
    }

    @Override
    protected Map<String, Method> getMethodMap() {
        return selfMethodMap;
    }
}

