/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc.proxy;

import bitronix.tm.resource.jdbc.JdbcPooledConnection;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.lrc.LrcXAResource;
import bitronix.tm.resource.jdbc.proxy.CallableStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ConnectionJavaProxy;
import bitronix.tm.resource.jdbc.proxy.JdbcJavaProxyFactory;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import bitronix.tm.resource.jdbc.proxy.PreparedStatementJavaProxy;
import bitronix.tm.resource.jdbc.proxy.ResultSetJavaProxy;
import bitronix.tm.resource.jdbc.proxy.StatementJavaProxy;
import bitronix.tm.utils.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassMap;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.sql.XAConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcJavassistProxyFactory
implements JdbcProxyFactory {
    private ClassMap classMap = new ClassMap();
    private ClassPool classPool;
    private Constructor<Connection> proxyConnectionConstructor;
    private Constructor<Statement> proxyStatementConstructor;
    private Constructor<CallableStatement> proxyCallableStatementConstructor;
    private Constructor<PreparedStatement> proxyPreparedStatementConstructor;
    private Constructor<ResultSet> proxyResultSetConstructor;
    private JdbcJavaProxyFactory lrcProxyFactory;

    JdbcJavassistProxyFactory() {
        ClassPool defaultPool = ClassPool.getDefault();
        this.classPool = new ClassPool(defaultPool);
        this.classPool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
        this.classPool.childFirstLookup = true;
        this.createProxyConnectionClass();
        this.createProxyStatementClass();
        this.createProxyCallableStatementClass();
        this.createProxyPreparedStatementClass();
        this.createProxyResultSetClass();
        this.lrcProxyFactory = new JdbcJavaProxyFactory();
        this.classMap.clear();
        this.classPool = null;
    }

    @Override
    public Connection getProxyConnection(JdbcPooledConnection jdbcPooledConnection, Connection connection) {
        try {
            return this.proxyConnectionConstructor.newInstance(jdbcPooledConnection, connection);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Statement getProxyStatement(JdbcPooledConnection jdbcPooledConnection, Statement statement) {
        try {
            return this.proxyStatementConstructor.newInstance(jdbcPooledConnection, statement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CallableStatement getProxyCallableStatement(JdbcPooledConnection jdbcPooledConnection, CallableStatement statement) {
        try {
            return this.proxyCallableStatementConstructor.newInstance(jdbcPooledConnection, statement);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PreparedStatement getProxyPreparedStatement(JdbcPooledConnection jdbcPooledConnection, PreparedStatement statement, LruStatementCache.CacheKey cacheKey) {
        try {
            return this.proxyPreparedStatementConstructor.newInstance(jdbcPooledConnection, statement, cacheKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResultSet getProxyResultSet(Statement statement, ResultSet resultSet) {
        try {
            return this.proxyResultSetConstructor.newInstance(statement, resultSet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XAConnection getProxyXaConnection(Connection connection) {
        return this.lrcProxyFactory.getProxyXaConnection(connection);
    }

    @Override
    public Connection getProxyConnection(LrcXAResource xaResource, Connection connection) {
        return this.lrcProxyFactory.getProxyConnection(xaResource, connection);
    }

    private void createProxyConnectionClass() {
        try {
            Class<Connection> proxyClass = this.generateProxyClass(Connection.class, ConnectionJavaProxy.class);
            this.proxyConnectionConstructor = proxyClass.getConstructor(JdbcPooledConnection.class, Connection.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProxyStatementClass() {
        try {
            Class<Statement> proxyClass = this.generateProxyClass(Statement.class, StatementJavaProxy.class);
            this.proxyStatementConstructor = proxyClass.getConstructor(JdbcPooledConnection.class, Statement.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProxyCallableStatementClass() {
        try {
            Class<CallableStatement> proxyClass = this.generateProxyClass(CallableStatement.class, CallableStatementJavaProxy.class);
            this.proxyCallableStatementConstructor = proxyClass.getConstructor(JdbcPooledConnection.class, CallableStatement.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProxyPreparedStatementClass() {
        try {
            Class<PreparedStatement> proxyClass = this.generateProxyClass(PreparedStatement.class, PreparedStatementJavaProxy.class);
            this.proxyPreparedStatementConstructor = proxyClass.getConstructor(JdbcPooledConnection.class, PreparedStatement.class, LruStatementCache.CacheKey.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createProxyResultSetClass() {
        try {
            Class<ResultSet> proxyClass = this.generateProxyClass(ResultSet.class, ResultSetJavaProxy.class);
            this.proxyResultSetConstructor = proxyClass.getConstructor(Statement.class, ResultSet.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Class<T> generateProxyClass(Class<T> primaryInterface, Class<?> superClass) throws NotFoundException, CannotCompileException, NoSuchMethodException, SecurityException {
        String superClassName = superClass.getName();
        CtClass superClassCt = this.classPool.getCtClass(superClassName);
        CtClass targetCt = this.classPool.makeClass(superClassName.replace("JavaProxy", "JavassistProxy"), superClassCt);
        for (CtConstructor constructor : superClassCt.getConstructors()) {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])constructor.getParameterTypes(), (CtClass[])constructor.getExceptionTypes(), (CtClass)targetCt);
            targetCt.addConstructor(ctConstructor);
        }
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superClassCt.getMethods()) {
            superSigs.add(method.getName() + method.getSignature());
        }
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = this.classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                if (superSigs.contains(intfMethod.getName() + intfMethod.getSignature())) continue;
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, (ClassMap)this.classMap);
                if (methods.contains(intfMethod.getName() + intfMethod.getSignature())) continue;
                methods.add(intfMethod.getName() + intfMethod.getSignature());
                StringBuilder call = new StringBuilder("{");
                if (method.getReturnType() != CtClass.voidType) {
                    call.append("return ");
                }
                call.append("((").append(primaryInterface.getName()).append(')');
                call.append("delegate).");
                call.append(method.getName()).append("($$);");
                call.append('}');
                method.setBody(call.toString());
                targetCt.addMethod(method);
            }
        }
        return targetCt.toClass(ClassLoaderUtils.getClassLoader(), null);
    }
}

