/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.timer;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.Recoverer;
import bitronix.tm.resource.common.XAPool;
import bitronix.tm.timer.PoolShrinkingTask;
import bitronix.tm.timer.RecoveryTask;
import bitronix.tm.timer.Task;
import bitronix.tm.timer.TransactionTimeoutTask;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Service;
import java.util.Date;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScheduler
extends Thread
implements Service {
    private static final Logger log = LoggerFactory.getLogger(TaskScheduler.class);
    private final SortedSet<Task> tasks;
    private final Lock tasksLock;
    private final AtomicBoolean active;

    public TaskScheduler() {
        ReentrantLock tasksLock;
        SortedSet tasks;
        block3: {
            this.active = new AtomicBoolean(true);
            this.setDaemon(true);
            this.setName("bitronix-task-scheduler");
            try {
                Class clazz = ClassLoaderUtils.loadClass("java.util.concurrent.ConcurrentSkipListSet");
                tasks = (SortedSet)clazz.newInstance();
                tasksLock = null;
                if (log.isDebugEnabled()) {
                    log.debug("task scheduler backed by ConcurrentSkipListSet");
                }
            }
            catch (Exception e) {
                tasks = new TreeSet();
                tasksLock = new ReentrantLock();
                if (!log.isDebugEnabled()) break block3;
                log.debug("task scheduler backed by locked TreeSet");
            }
        }
        this.tasks = tasks;
        this.tasksLock = tasksLock;
    }

    private void lock() {
        if (this.tasksLock != null) {
            this.tasksLock.lock();
        }
    }

    private void unlock() {
        if (this.tasksLock != null) {
            this.tasksLock.unlock();
        }
    }

    private SortedSet<Task> getSafeIterableTasks() {
        if (this.tasksLock != null) {
            return new TreeSet<Task>(this.tasks);
        }
        return this.tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countTasksQueued() {
        this.lock();
        try {
            int n = this.tasks.size();
            Object var3_2 = null;
            this.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public void shutdown() {
        boolean wasActive = this.setActive(false);
        if (wasActive) {
            try {
                long gracefulShutdownTime = TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() * 1000;
                if (log.isDebugEnabled()) {
                    log.debug("graceful scheduler shutdown interval: " + gracefulShutdownTime + "ms");
                }
                this.join(gracefulShutdownTime);
            }
            catch (InterruptedException ex) {
                log.error("could not stop the task scheduler within " + TransactionManagerServices.getConfiguration().getGracefulShutdownInterval() + "s");
            }
        }
    }

    public void scheduleTransactionTimeout(BitronixTransaction transaction, Date executionTime) {
        if (log.isDebugEnabled()) {
            log.debug("scheduling transaction timeout task on " + transaction + " for " + executionTime);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        TransactionTimeoutTask task = new TransactionTimeoutTask(transaction, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.countTasksQueued());
        }
    }

    public void cancelTransactionTimeout(BitronixTransaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling transaction timeout task on " + transaction);
        }
        if (transaction == null) {
            throw new IllegalArgumentException("expected a non-null transaction");
        }
        if (!this.removeTaskByObject(transaction) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + transaction);
        }
    }

    public void scheduleRecovery(Recoverer recoverer, Date executionTime) {
        if (log.isDebugEnabled()) {
            log.debug("scheduling recovery task for " + executionTime);
        }
        if (recoverer == null) {
            throw new IllegalArgumentException("expected a non-null recoverer");
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        RecoveryTask task = new RecoveryTask(recoverer, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.countTasksQueued());
        }
    }

    public void cancelRecovery(Recoverer recoverer) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling recovery task");
        }
        if (!this.removeTaskByObject(recoverer) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + recoverer);
        }
    }

    public void schedulePoolShrinking(XAPool xaPool) {
        Date executionTime = xaPool.getNextShrinkDate();
        if (log.isDebugEnabled()) {
            log.debug("scheduling pool shrinking task on " + xaPool + " for " + executionTime);
        }
        if (executionTime == null) {
            throw new IllegalArgumentException("expected a non-null execution date");
        }
        PoolShrinkingTask task = new PoolShrinkingTask(xaPool, executionTime, this);
        this.addTask(task);
        if (log.isDebugEnabled()) {
            log.debug("scheduled " + task + ", total task(s) queued: " + this.tasks.size());
        }
    }

    public void cancelPoolShrinking(XAPool xaPool) {
        if (log.isDebugEnabled()) {
            log.debug("cancelling pool shrinking task on " + xaPool);
        }
        if (xaPool == null) {
            throw new IllegalArgumentException("expected a non-null XA pool");
        }
        if (!this.removeTaskByObject(xaPool) && log.isDebugEnabled()) {
            log.debug("no task found based on object " + xaPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTask(Task task) {
        this.lock();
        try {
            this.removeTaskByObject(task.getObject());
            this.tasks.add(task);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean removeTaskByObject(Object obj) {
        boolean bl;
        this.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug("removing task by " + obj);
            }
            for (Task task : this.tasks) {
                if (task.getObject() != obj) continue;
                this.tasks.remove(task);
                if (log.isDebugEnabled()) {
                    log.debug("cancelled " + task + ", total task(s) still queued: " + this.tasks.size());
                }
                boolean bl2 = true;
                Object var6_6 = null;
                this.unlock();
                return bl2;
            }
            bl = false;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.unlock();
        return bl;
    }

    boolean setActive(boolean active) {
        return this.active.getAndSet(active);
    }

    private boolean isActive() {
        return this.active.get();
    }

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                this.executeElapsedTasks();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeElapsedTasks() {
        this.lock();
        try {
            if (this.tasks.isEmpty()) {
                Object var8_1 = null;
                this.unlock();
                return;
            }
            HashSet<Task> toRemove = new HashSet<Task>();
            for (Task task : this.getSafeIterableTasks()) {
                Object var6_8;
                if (task.getExecutionTime().compareTo(new Date(MonotonicClock.currentTimeMillis())) > 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug("running " + task);
                }
                try {
                    block9: {
                        try {
                            task.execute();
                            if (!log.isDebugEnabled()) break block9;
                            log.debug("successfully ran " + task);
                        }
                        catch (Exception ex) {
                            log.warn("error running " + task, (Throwable)ex);
                            var6_8 = null;
                            toRemove.add(task);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("total task(s) still queued: " + this.tasks.size());
                            continue;
                        }
                    }
                    var6_8 = null;
                    toRemove.add(task);
                }
                catch (Throwable throwable) {
                    var6_8 = null;
                    toRemove.add(task);
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug("total task(s) still queued: " + this.tasks.size());
                    throw throwable;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("total task(s) still queued: " + this.tasks.size());
            }
            this.tasks.removeAll(toRemove);
        }
        catch (Throwable throwable) {
            Object var8_3 = null;
            this.unlock();
            throw throwable;
        }
        Object var8_2 = null;
        this.unlock();
    }
}

