/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.ExecutorServiceEntryPoint;
import org.jbpm.executor.api.Executor;
import org.jbpm.executor.api.ExecutorQueryService;
import org.jbpm.executor.api.ExecutorRequestAdminService;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.ExecutorRunnable;
import org.jbpm.executor.impl.ExecutorServiceEntryPointImpl;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.jbpm.shared.services.impl.JbpmLocalTransactionManager;
import org.jbpm.shared.services.impl.JbpmServicesPersistenceManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorServiceFactory.class);
    private static ExecutorServiceEntryPoint service = new ExecutorServiceEntryPointImpl();
    private static JbpmServicesPersistenceManager pm = new JbpmServicesPersistenceManagerImpl();
    private static EntityManagerFactory emf;
    private static JbpmServicesTransactionManager jbpmTransactionManager;
    private static ExecutorQueryService queryService;
    private static Executor executor;
    private static ExecutorRequestAdminService adminService;

    public static ExecutorServiceEntryPoint newExecutorService() {
        ExecutorServiceFactory.configure();
        return service;
    }

    private static void configure() {
        ExecutorServiceFactory.configurePersistenceManager();
        ((ExecutorQueryServiceImpl)queryService).setPm(pm);
        ((ExecutorServiceEntryPointImpl)service).setQueryService(queryService);
        ExecutorServiceFactory.configureExecutorImpl();
        ((ExecutorServiceEntryPointImpl)service).setExecutor(executor);
        ((ExecutorRequestAdminServiceImpl)adminService).setPm(pm);
        ((ExecutorServiceEntryPointImpl)service).setAdminService(adminService);
    }

    public static void setEmf(EntityManagerFactory emf) {
        ExecutorServiceFactory.emf = emf;
    }

    public static void setJbpmTransactionManager(JbpmServicesTransactionManager jbpmTransactionManager) {
        ExecutorServiceFactory.jbpmTransactionManager = jbpmTransactionManager;
    }

    public static void configurePersistenceManager() {
        EntityManager em = emf.createEntityManager();
        ((JbpmServicesPersistenceManagerImpl)pm).setEm(em);
        ((JbpmServicesPersistenceManagerImpl)pm).setTransactionManager(jbpmTransactionManager);
    }

    public static void configureExecutorImpl() {
        ExecutorRunnable runnable = new ExecutorRunnable();
        runnable.setPm(pm);
        runnable.setQueryService(queryService);
        ((ExecutorImpl)executor).setPm(pm);
        ((ExecutorImpl)executor).setExecutorRunnable(runnable);
        ((ExecutorImpl)executor).setQueryService(queryService);
        ((ExecutorImpl)executor).setRequestEvents(service.getExecutorEventListeners());
    }

    static {
        jbpmTransactionManager = new JbpmLocalTransactionManager();
        queryService = new ExecutorQueryServiceImpl();
        executor = new ExecutorImpl();
        adminService = new ExecutorRequestAdminServiceImpl();
    }
}

