/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jboss.seam.transaction.Transactional;
import org.jbpm.executor.api.Command;
import org.jbpm.executor.api.CommandCallback;
import org.jbpm.executor.api.CommandContext;
import org.jbpm.executor.api.ExecutionResults;
import org.jbpm.executor.api.ExecutorQueryService;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.entities.STATUS;
import org.jbpm.shared.services.api.JbpmServicesPersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorRunnable.class);
    @Inject
    private JbpmServicesPersistenceManager pm;
    @Inject
    private ExecutorQueryService queryService;
    private final Map<String, Command> commandCache = new HashMap<String, Command>();
    private final Map<String, CommandCallback> callbackCache = new HashMap<String, CommandCallback>();

    public void setPm(JbpmServicesPersistenceManager pm) {
        this.pm = pm;
    }

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    @Override
    @Transactional
    public void run() {
        logger.debug("Executor Thread {} Waking Up!!!", (Object)this.toString());
        List<RequestInfo> resultList = this.queryService.getPendingRequests();
        logger.debug("Pending Requests = {}", (Object)resultList.size());
        if (resultList.size() > 0) {
            RequestInfo r = null;
            Throwable exception = null;
            try {
                r = resultList.get(0);
                r.setStatus(STATUS.RUNNING);
                this.pm.merge((Object)r);
                logger.debug("Processing Request Id: {}", (Object)r.getId());
                logger.debug("Request Status ={}", (Object)r.getStatus());
                logger.debug("Command Name to execute = {}", (Object)r.getCommandName());
                Command cmd = this.findCommand(r.getCommandName());
                CommandContext ctx = null;
                byte[] reqData = r.getRequestData();
                if (reqData != null) {
                    try {
                        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(reqData));
                        ctx = (CommandContext)in.readObject();
                    }
                    catch (IOException e) {
                        ctx = null;
                        e.printStackTrace();
                    }
                }
                ExecutionResults results = cmd.execute(ctx);
                if (ctx != null && ctx.getData("callbacks") != null) {
                    logger.debug("Callback: {}", ctx.getData("callbacks"));
                    String[] callbacksArray = ((String)ctx.getData("callbacks")).split(",");
                    List<String> callbacks = Arrays.asList(callbacksArray);
                    for (String callbackName : callbacks) {
                        CommandCallback handler = this.findCommandCallback(callbackName);
                        handler.onCommandDone(ctx, results);
                    }
                } else {
                    logger.debug("Callbacks: NULL");
                }
                if (results != null) {
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(bout);
                        out.writeObject(results);
                        byte[] respData = bout.toByteArray();
                        r.setResponseData(respData);
                    }
                    catch (IOException e) {
                        r.setResponseData(null);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                e.printStackTrace();
                exception = e;
            }
            if (exception != null) {
                logger.debug("{} Before - Error Handling!!!{}", (Object)System.currentTimeMillis(), (Object)exception.getMessage());
                ErrorInfo errorInfo = new ErrorInfo(exception.getMessage(), ExceptionUtils.getFullStackTrace((Throwable)exception.fillInStackTrace()));
                errorInfo.setRequestInfo(r);
                r.getErrorInfo().add(errorInfo);
                logger.debug("Error Number: {}", (Object)r.getErrorInfo().size());
                if (r.getRetries() > 0) {
                    r.setStatus(STATUS.RETRYING);
                    r.setRetries(r.getRetries() - 1);
                    r.setExecutions(r.getExecutions() + 1);
                    logger.debug("Retrying ({}) still available!", (Object)r.getRetries());
                } else {
                    logger.debug("Error no retries left!");
                    r.setStatus(STATUS.ERROR);
                    r.setExecutions(r.getExecutions() + 1);
                }
                this.pm.merge((Object)r);
                logger.debug("After - Error Handling!!!");
            } else {
                r.setStatus(STATUS.DONE);
                this.pm.merge((Object)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command findCommand(String name) {
        Map<String, Command> map = this.commandCache;
        synchronized (map) {
            if (!this.commandCache.containsKey(name)) {
                try {
                    Command commandInstance = (Command)Class.forName(name).newInstance();
                    this.commandCache.put(name, commandInstance);
                }
                catch (Exception ex) {
                    logger.error("Unknown Command implemenation with name '{}'", (Object)name);
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
        }
        return this.commandCache.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandCallback findCommandCallback(String name) {
        Map<String, CommandCallback> map = this.callbackCache;
        synchronized (map) {
            if (!this.callbackCache.containsKey(name)) {
                try {
                    CommandCallback commandCallbackInstance = (CommandCallback)Class.forName(name).newInstance();
                    this.callbackCache.put(name, commandCallbackInstance);
                }
                catch (Exception ex) {
                    logger.error("Unknown CommandCallback implemenation with name '{}'", (Object)name);
                    throw new IllegalArgumentException("Unknown Command implemenation with name '" + name + "'");
                }
            }
        }
        return this.callbackCache.get(name);
    }
}

