/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.MarshallingConfigurationImpl;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProtobufProcessMarshaller;
import org.jbpm.services.task.impl.model.ContentDataImpl;
import org.jbpm.services.task.impl.model.FaultDataImpl;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.internal.task.api.model.AccessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentMarshallerHelper {
    private static final Logger logger = LoggerFactory.getLogger(ContentMarshallerHelper.class);

    public static ContentDataImpl marshal(Object o, Environment env) {
        if (o == null) {
            return null;
        }
        Object context = null;
        ContentDataImpl content = null;
        byte[] toByteArray = ContentMarshallerHelper.marshallContent(env, o);
        content = new ContentDataImpl();
        content.setContent(toByteArray);
        content.setType(o.getClass().getCanonicalName());
        content.setAccessType(AccessType.Inline);
        return content;
    }

    public static FaultDataImpl marshalFault(Map<String, Object> fault, Environment env) {
        FaultDataImpl content = null;
        byte[] toByteArray = ContentMarshallerHelper.marshallContent(env, fault);
        content = new FaultDataImpl();
        content.setContent(toByteArray);
        content.setType(fault.getClass().getCanonicalName());
        content.setAccessType(AccessType.Inline);
        content.setFaultName((String)fault.get("faultName"));
        content.setType((String)fault.get("faultType"));
        return content;
    }

    public static Object unmarshall(byte[] content, Environment env) {
        return ContentMarshallerHelper.unmarshall(content, env, null);
    }

    public static Object unmarshall(byte[] content, Environment env, ClassLoader classloader) {
        MarshallerReaderContext context = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            MarshallingConfigurationImpl marshallingConfigurationImpl = null;
            marshallingConfigurationImpl = env != null ? new MarshallingConfigurationImpl((ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies"), false, false) : new MarshallingConfigurationImpl(new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)}, false, false);
            ObjectMarshallingStrategyStore objectMarshallingStrategyStore = marshallingConfigurationImpl.getObjectMarshallingStrategyStore();
            context = new MarshallerReaderContext((InputStream)stream, null, null, objectMarshallingStrategyStore, null, env);
            context.classLoader = classloader != null ? classloader : ContentMarshallerHelper.class.getClassLoader();
            ExtensionRegistry registry = PersisterHelper.buildRegistry((MarshallerReaderContext)context, null);
            ProtobufMessages.Header _header = PersisterHelper.readFromStreamWithHeaderPreloaded((MarshallerReaderContext)context, (ExtensionRegistry)registry);
            JBPMMessages.Variable parseFrom = JBPMMessages.Variable.parseFrom((ByteString)_header.getPayload(), (ExtensionRegistryLite)registry);
            Object value = ProtobufProcessMarshaller.unmarshallVariableValue((MarshallerReaderContext)context, (JBPMMessages.Variable)parseFrom);
            if (value instanceof Map) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                Map variablesMap = (Map)value;
                for (String key : variablesMap.keySet()) {
                    result.put(key, ProtobufProcessMarshaller.unmarshallVariableValue((MarshallerReaderContext)context, (JBPMMessages.Variable)((JBPMMessages.Variable)variablesMap.get(key))));
                }
                return result;
            }
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static byte[] marshallContent(Environment env, Object o) {
        try {
            MarshallingConfigurationImpl marshallingConfigurationImpl = null;
            marshallingConfigurationImpl = env != null ? new MarshallingConfigurationImpl((ObjectMarshallingStrategy[])env.get("org.kie.api.marshalling.ObjectMarshallingStrategies"), false, false) : new MarshallingConfigurationImpl(new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)}, false, false);
            ObjectMarshallingStrategyStore objectMarshallingStrategyStore = marshallingConfigurationImpl.getObjectMarshallingStrategyStore();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            MarshallerWriteContext context = new MarshallerWriteContext((OutputStream)stream, null, null, null, objectMarshallingStrategyStore, env);
            JBPMMessages.Variable marshallVariable = null;
            marshallVariable = o instanceof Map ? ProtobufProcessMarshaller.marshallVariablesMap((MarshallerWriteContext)context, (Map)((Map)o)) : ProtobufProcessMarshaller.marshallVariable((MarshallerWriteContext)context, (String)"results", (Object)o);
            PersisterHelper.writeToStreamWithHeader((MarshallerWriteContext)context, (Message)marshallVariable);
            context.close();
            return stream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

