/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Subquery;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

public class InPredicate<T>
extends AbstractSimplePredicate
implements CriteriaBuilder.In<T>,
Serializable {
    private final Expression<? extends T> expression;
    private final List<Expression<? extends T>> values;

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression) {
        this(criteriaBuilder, expression, (List<Expression<? extends T>>)new ArrayList<Expression<? extends T>>());
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, Expression<? extends T> ... values) {
        this(criteriaBuilder, expression, Arrays.asList(values));
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, List<Expression<? extends T>> values) {
        super(criteriaBuilder);
        this.expression = expression;
        this.values = values;
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, T ... values) {
        this(criteriaBuilder, expression, (Collection<? extends T>)Arrays.asList(values));
    }

    public InPredicate(CriteriaBuilderImpl criteriaBuilder, Expression<? extends T> expression, Collection<T> values) {
        super(criteriaBuilder);
        this.expression = expression;
        this.values = new ArrayList<Expression<? extends T>>(values.size());
        ValueHandlerFactory.ValueHandler valueHandler = ValueHandlerFactory.isNumeric(expression.getJavaType()) ? ValueHandlerFactory.determineAppropriateHandler(expression.getJavaType()) : new ValueHandlerFactory.NoOpValueHandler();
        for (T value : values) {
            this.values.add(new LiteralExpression(criteriaBuilder, valueHandler.convert(value)));
        }
    }

    public Expression<T> getExpression() {
        return this.expression;
    }

    public Expression<? extends T> getExpressionInternal() {
        return this.expression;
    }

    public List<Expression<? extends T>> getValues() {
        return this.values;
    }

    public InPredicate<T> value(T value) {
        return this.value(new LiteralExpression<T>(this.criteriaBuilder(), value));
    }

    public InPredicate<T> value(Expression<? extends T> value) {
        this.values.add(value);
        return this;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getExpressionInternal(), registry);
        for (Expression<T> value : this.getValues()) {
            ParameterContainer.Helper.possibleParameter(value, registry);
        }
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        boolean isInSubqueryPredicate;
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Renderable)this.getExpression()).render(renderingContext));
        if (this.isNegated()) {
            buffer.append(" not");
        }
        buffer.append(" in ");
        boolean bl = isInSubqueryPredicate = this.getValues().size() == 1 && Subquery.class.isInstance(this.getValues().get(0));
        if (isInSubqueryPredicate) {
            buffer.append(((Renderable)this.getValues().get(0)).render(renderingContext));
        } else {
            buffer.append('(');
            String sep = "";
            for (Expression<T> value : this.getValues()) {
                buffer.append(sep).append(((Renderable)value).render(renderingContext));
                sep = ", ";
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

