/*
 * Decompiled with CFR 0.152.
 */
package org.kie.scanner;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.common.ProjectClassLoader;
import org.drools.core.rule.TypeMetaInfo;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.scanner.ArtifactResolver;
import org.kie.scanner.DependencyDescriptor;
import org.kie.scanner.KieModuleMetaData;
import org.sonatype.aether.artifact.Artifact;

public class KieModuleMetaDataImpl
implements KieModuleMetaData {
    private final ArtifactResolver artifactResolver;
    private final Map<String, Collection<String>> classes = new HashMap<String, Collection<String>>();
    private final Map<String, String> processes = new HashMap<String, String>();
    private final Map<URI, File> jars = new HashMap<URI, File>();
    private final Map<String, TypeMetaInfo> typeMetaInfos = new HashMap<String, TypeMetaInfo>();
    private ProjectClassLoader classLoader;
    private ReleaseId releaseId;
    private InternalKieModule kieModule;

    public KieModuleMetaDataImpl(ReleaseId releaseId) {
        this.artifactResolver = ArtifactResolver.getResolverFor(releaseId, false);
        this.releaseId = releaseId;
        this.init();
    }

    public KieModuleMetaDataImpl(File pomFile) {
        this.artifactResolver = ArtifactResolver.getResolverFor(pomFile);
        this.init();
    }

    public KieModuleMetaDataImpl(InternalKieModule kieModule) {
        String pomXmlPath = ((ReleaseIdImpl)kieModule.getReleaseId()).getPomXmlPath();
        ByteArrayInputStream pomStream = new ByteArrayInputStream(kieModule.getBytes(pomXmlPath));
        this.artifactResolver = ArtifactResolver.getResolverFor(pomStream);
        this.kieModule = kieModule;
        for (String file : kieModule.getFileNames()) {
            if (this.indexClass(file) || !file.endsWith(KieModuleModelImpl.KMODULE_INFO_JAR_PATH)) continue;
            this.indexMetaInfo(kieModule.getBytes(file));
        }
        this.init();
    }

    @Override
    public Collection<String> getPackages() {
        return this.classes.keySet();
    }

    @Override
    public Collection<String> getClasses(String packageName) {
        Collection<String> classesInPkg = this.classes.get(packageName);
        return classesInPkg != null ? classesInPkg : Collections.emptyList();
    }

    @Override
    public Class<?> getClass(String pkgName, String className) {
        try {
            return Class.forName(pkgName == null || pkgName.trim().length() == 0 ? className : pkgName + "." + className, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public TypeMetaInfo getTypeMetaInfo(Class<?> clazz) {
        TypeMetaInfo typeMetaInfo = this.typeMetaInfos.get(clazz.getName());
        return typeMetaInfo != null ? typeMetaInfo : new TypeMetaInfo(clazz);
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            URL[] urls = new URL[this.jars.size()];
            int i = 0;
            for (File jar : this.jars.values()) {
                try {
                    urls[i++] = jar.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.classLoader = ProjectClassLoader.createProjectClassLoader((ClassLoader)new URLClassLoader(urls));
            this.classLoader.setDroolsClassLoader(this.getClass().getClassLoader());
            if (this.kieModule != null) {
                Map classes = this.kieModule.getClassesMap(true);
                for (Map.Entry entry : classes.entrySet()) {
                    this.classLoader.storeClass(ClassUtils.convertResourceToClassName((String)((String)entry.getKey())), (String)entry.getKey(), (byte[])entry.getValue());
                }
            }
        }
        return this.classLoader;
    }

    private void init() {
        if (this.releaseId != null) {
            this.addArtifact(this.artifactResolver.resolveArtifact(this.releaseId.toString()));
        }
        for (DependencyDescriptor dep : this.artifactResolver.getAllDependecies()) {
            this.addArtifact(this.artifactResolver.resolveArtifact(dep.toString()));
        }
    }

    private void addArtifact(Artifact artifact) {
        if (artifact != null && artifact.getExtension() != null && artifact.getExtension().equals("jar")) {
            this.addJar(artifact.getFile());
        }
    }

    private void addJar(File jarFile) {
        URI uri = jarFile.toURI();
        if (!this.jars.containsKey(uri)) {
            this.jars.put(uri, jarFile);
            this.scanJar(jarFile);
        }
    }

    private void scanJar(File jarFile) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String pathName = entry.getName();
                if (pathName.endsWith("bpmn2")) {
                    this.processes.put(pathName, new String(IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry)));
                }
                if (this.indexClass(pathName) || !pathName.endsWith(KieModuleModelImpl.KMODULE_INFO_JAR_PATH)) continue;
                this.indexMetaInfo(IoUtils.readBytesFromZipEntry((File)jarFile, (ZipEntry)entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean indexClass(String pathName) {
        if (!pathName.endsWith(".class")) {
            return false;
        }
        int separator = pathName.lastIndexOf(47);
        String packageName = separator > 0 ? pathName.substring(0, separator).replace('/', '.') : "";
        String className = pathName.substring(separator + 1, pathName.length() - ".class".length());
        Collection<String> pkg = this.classes.get(packageName);
        if (pkg == null) {
            pkg = new HashSet<String>();
            this.classes.put(packageName, pkg);
        }
        pkg.add(className);
        return true;
    }

    private void indexMetaInfo(byte[] bytes) {
        this.typeMetaInfos.putAll(TypeMetaInfo.unmarshallMetaInfos((String)new String(bytes)));
    }

    @Override
    public Map<String, String> getProcesses() {
        return this.processes;
    }
}

