/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.AgendaGroupQueueImpl;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalRuleFlowGroup;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.ScheduledAgendaItem;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.common.WorkingMemoryFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProcessMarshaller;
import org.drools.core.marshalling.impl.ProcessMarshallerFactory;
import org.drools.core.marshalling.impl.RightTupleKey;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.InitialFactImpl;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleImpl;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Package;
import org.drools.core.rule.Rule;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.Activation;
import org.drools.core.spi.FactHandleFactory;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.StringUtils;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.rule.EntryPoint;

public class InputMarshaller {
    private static ProcessMarshaller processMarshaller = InputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static AbstractWorkingMemory readSession(AbstractWorkingMemory session, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        long time = context.readLong();
        int handleId = context.readInt();
        long handleCounter = context.readLong();
        long propagationCounter = context.readLong();
        context.readInt();
        context.readLong();
        session.reset(handleId, handleCounter, propagationCounter);
        InternalAgenda agenda = (InternalAgenda)session.getAgenda();
        InputMarshaller.readAgenda(context, agenda);
        return InputMarshaller.readSession(session, agenda, time, multithread, context);
    }

    public static AbstractWorkingMemory readSession(MarshallerReaderContext context, int id) throws IOException, ClassNotFoundException {
        return InputMarshaller.readSession(context, id, EnvironmentFactory.newEnvironment(), SessionConfiguration.getDefaultInstance());
    }

    public static AbstractWorkingMemory readSession(MarshallerReaderContext context, int id, Environment environment, SessionConfiguration config) throws IOException, ClassNotFoundException {
        boolean multithread = context.readBoolean();
        long time = context.readLong();
        FactHandleFactory handleFactory = context.ruleBase.newFactHandleFactory(context.readInt(), context.readLong());
        long propagationCounter = context.readLong();
        DefaultFactHandle initialFactHandle = new DefaultFactHandle(context.readInt(), InitialFactImpl.getInstance(), context.readLong(), null);
        context.handles.put(initialFactHandle.getId(), initialFactHandle);
        InternalAgenda agenda = context.ruleBase.getConfiguration().getComponentFactory().getAgendaFactory().createAgenda(context.ruleBase, false);
        InputMarshaller.readAgenda(context, agenda);
        WorkingMemoryFactory wmFactory = context.ruleBase.getConfiguration().getComponentFactory().getWorkingMemoryFactory();
        AbstractWorkingMemory session = (AbstractWorkingMemory)wmFactory.createWorkingMemory(id, context.ruleBase, handleFactory, initialFactHandle, propagationCounter, config, agenda, environment);
        new StatefulKnowledgeSessionImpl(session);
        initialFactHandle.setEntryPoint(session.getEntryPoints().get(EntryPointId.DEFAULT.getEntryPointId()));
        return InputMarshaller.readSession(session, agenda, time, multithread, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractWorkingMemory readSession(AbstractWorkingMemory session, InternalAgenda agenda, long time, boolean multithread, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        if (session.getTimerService() instanceof PseudoClockScheduler) {
            PseudoClockScheduler clock = (PseudoClockScheduler)session.getTimerService();
            clock.advanceTime(time, TimeUnit.MILLISECONDS);
        }
        for (InternalAgendaGroup group : agenda.getAgendaGroupsMap().values()) {
            ((InternalRuleFlowGroup)group).setWorkingMemory(session);
        }
        context.wm = session;
        context.handles.put(context.wm.getInitialFactHandle().getId(), context.wm.getInitialFactHandle());
        if (context.stream.readBoolean()) {
            InternalFactHandle initialFactHandle = context.wm.getInitialFactHandle();
            int sinkId = context.stream.readInt();
            ObjectTypeNode initialFactNode = (ObjectTypeNode)context.sinks.get(sinkId);
            if (initialFactNode == null) {
                EntryPointNode defaultEPNode = context.ruleBase.getRete().getEntryPointNode(EntryPointId.DEFAULT);
                BuildContext buildContext = new BuildContext(context.ruleBase, context.ruleBase.getReteooBuilder().getIdGenerator());
                buildContext.setPartitionId(RuleBasePartitionId.MAIN_PARTITION);
                buildContext.setObjectTypeNodeMemoryEnabled(true);
                initialFactNode = new ObjectTypeNode(sinkId, defaultEPNode, ClassObjectType.InitialFact_ObjectType, buildContext);
                context.ruleBase.lock();
                try {
                    initialFactNode.attach(buildContext);
                }
                finally {
                    context.ruleBase.unlock();
                }
            }
            ObjectHashSet initialFactMemory = (ObjectHashSet)((Object)context.wm.getNodeMemory(initialFactNode));
            initialFactMemory.add(initialFactHandle);
            InputMarshaller.readRightTuples(initialFactHandle, context);
        }
        while (context.readShort() == 90) {
            String entryPointId = context.stream.readUTF();
            EntryPoint wmep = context.wm.getEntryPoints().get(entryPointId);
            InputMarshaller.readFactHandles(context, ((NamedEntryPoint)wmep).getObjectStore());
        }
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        while (context.stream.readShort() == 3) {
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(context.stream.readInt()));
            LeftTuple leftTuple = sink.createLeftTuple(handle, sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
        InputMarshaller.readPropagationContexts(context);
        InputMarshaller.readActivations(context);
        InputMarshaller.readActionQueue(context);
        InputMarshaller.readTruthMaintenanceSystem(context);
        if (processMarshaller != null) {
            processMarshaller.readProcessInstances(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        if (processMarshaller != null) {
            processMarshaller.readWorkItems(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        if (processMarshaller != null) {
            processMarshaller.readProcessTimers(context);
        } else {
            short type = context.stream.readShort();
            if (1 != type) {
                throw new IllegalStateException("No process marshaller, unable to unmarshall type: " + type);
            }
        }
        while (context.readShort() == 50) {
            InputMarshaller.readTimer(context);
        }
        return session;
    }

    public static void readAgenda(MarshallerReaderContext context, InternalAgenda agenda) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 13) {
            AgendaGroupQueueImpl group = new AgendaGroupQueueImpl(stream.readUTF(), context.ruleBase);
            group.setActive(stream.readBoolean());
            group.setActivatedForRecency(stream.readLong());
            agenda.getAgendaGroupsMap().put(group.getName(), group);
        }
        while (stream.readShort() == 13) {
            String agendaGroupName = stream.readUTF();
            agenda.addAgendaGroupOnStack(agenda.getAgendaGroup(agendaGroupName));
        }
    }

    public static void readActionQueue(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        AbstractWorkingMemory wm = (AbstractWorkingMemory)context.wm;
        Queue<WorkingMemoryAction> actionQueue = wm.getActionQueue();
        while (context.readShort() == 10) {
            actionQueue.offer(PersisterHelper.readWorkingMemoryAction(context));
        }
    }

    public static void readTruthMaintenanceSystem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        throw new UnsupportedOperationException();
    }

    public static void readFactHandles(MarshallerReaderContext context, ObjectStore objectStore) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        int size = stream.readInt();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        for (int i = 0; i < size; ++i) {
            InternalFactHandle handle = InputMarshaller.readFactHandle(context);
            context.handles.put(handle.getId(), handle);
            handles[i] = handle;
            if (handle.getObject() != null) {
                objectStore.addHandle(handle, handle.getObject());
            }
            InputMarshaller.readRightTuples(handle, context);
        }
        InputMarshaller.readLeftTuples(context);
        if (stream.readBoolean()) {
            InputMarshaller.readLeftTuples(context);
        }
        for (InternalFactHandle factHandle : handles) {
            Object object = factHandle.getObject();
            EntryPointId ep = ((InternalWorkingMemoryEntryPoint)factHandle.getEntryPoint()).getEntryPoint();
            ObjectTypeConf typeConf = ((InternalWorkingMemoryEntryPoint)factHandle.getEntryPoint()).getObjectTypeConfigurationRegistry().getObjectTypeConf(ep, object);
            ObjectTypeNode[] cachedNodes = typeConf.getObjectTypeNodes();
            int length = cachedNodes.length;
            for (int i = 0; i < length; ++i) {
                ObjectHashSet set = (ObjectHashSet)((Object)wm.getNodeMemory(cachedNodes[i]));
                set.add(factHandle, false);
            }
        }
    }

    public static InternalFactHandle readFactHandle(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        String entryPointId;
        String strategyClassName;
        int type = context.stream.readInt();
        int id = context.stream.readInt();
        long recency = context.stream.readLong();
        long startTimeStamp = 0L;
        long duration = 0L;
        boolean expired = false;
        long activationsCount = 0L;
        if (type == 2) {
            startTimeStamp = context.stream.readLong();
            duration = context.stream.readLong();
            expired = context.stream.readBoolean();
            activationsCount = context.stream.readLong();
        }
        int strategyIndex = context.stream.readInt();
        Object object = null;
        ObjectMarshallingStrategy strategy = null;
        if (strategyIndex >= 0) {
            strategy = context.resolverStrategyFactory.getStrategy(strategyIndex);
        } else if (strategyIndex == -2 && !StringUtils.isEmpty(strategyClassName = context.stream.readUTF()) && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName)) == null) {
            throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
        }
        if (strategy != null) {
            object = strategy.read((ObjectInputStream)context.stream);
        }
        EntryPoint entryPoint = null;
        if (context.readBoolean() && (entryPointId = context.readUTF()) != null && !entryPointId.equals("")) {
            entryPoint = context.wm.getEntryPoints().get(entryPointId);
        }
        InternalFactHandle handle = null;
        switch (type) {
            case 0: {
                handle = new DefaultFactHandle(id, object, recency, entryPoint);
                break;
            }
            case 1: {
                handle = new QueryElementFactHandle(object, id, recency);
                break;
            }
            case 2: {
                handle = new EventFactHandle(id, object, recency, startTimeStamp, duration, entryPoint);
                ((EventFactHandle)handle).setExpired(expired);
                ((EventFactHandle)handle).setActivationsCount(activationsCount);
                break;
            }
            default: {
                throw new IllegalStateException("Unable to marshal FactHandle, as type does not exist:" + type);
            }
        }
        return handle;
    }

    public static void readRightTuples(InternalFactHandle factHandle, MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 4) {
            InputMarshaller.readRightTuple(context, factHandle);
        }
    }

    public static void readRightTuple(MarshallerReaderContext context, InternalFactHandle factHandle) throws IOException {
        MarshallerReaderContext stream = context.stream;
        int sinkId = stream.readInt();
        RightTupleSink sink = sinkId >= 0 ? (RightTupleSink)((Object)context.sinks.get(sinkId)) : null;
        RightTuple rightTuple = new RightTuple(factHandle, sink);
        context.rightTuples.put(new RightTupleKey(factHandle.getId(), sink), rightTuple);
        if (sink != null) {
            BetaMemory memory = null;
            switch (sink.getType()) {
                case 211: {
                    memory = ((AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((MemoryFactory)((BetaNode)sink))).betaMemory;
                    break;
                }
                default: {
                    memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                }
            }
            memory.getRightTupleMemory().add(rightTuple);
        }
    }

    public static void readLeftTuples(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 3) {
            int nodeId = stream.readInt();
            LeftTupleSink sink = (LeftTupleSink)((Object)context.sinks.get(nodeId));
            int factHandleId = stream.readInt();
            LeftTuple leftTuple = sink.createLeftTuple(context.handles.get(factHandleId), sink, true);
            InputMarshaller.readLeftTuple(leftTuple, context);
        }
    }

    public static void readLeftTuple(LeftTuple parentLeftTuple, MarshallerReaderContext context) throws IOException, ClassNotFoundException {
        MarshallerReaderContext stream = context.stream;
        Map<Integer, BaseNode> sinks = context.sinks;
        LeftTupleSink sink = parentLeftTuple.getLeftTupleSink();
        block0 : switch (sink.getType()) {
            case 181: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                while (stream.readShort() == 4) {
                    int childSinkId = stream.readInt();
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(childSinkId));
                    int factHandleId = stream.readInt();
                    RightTupleKey key = new RightTupleKey(factHandleId, sink);
                    RightTuple rightTuple = context.rightTuples.get(key);
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, rightTuple, null, null, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 131: {
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, parentLeftTuple.getPropagationContext(), true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 191: 
            case 221: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                short type = stream.readShort();
                if (type == 7) {
                    InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                    while (stream.readShort() == 3) {
                        LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                        LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, parentLeftTuple.getPropagationContext(), true);
                        InputMarshaller.readLeftTuple(childLeftTuple, context);
                    }
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(parentLeftTuple);
                break;
            }
            case 201: {
                BetaMemory memory = (BetaMemory)context.wm.getNodeMemory((BetaNode)sink);
                short type = stream.readShort();
                if (type == 7) {
                    InputMarshaller.addToLeftMemory(parentLeftTuple, memory);
                    break;
                }
                int factHandleId = stream.readInt();
                RightTupleKey key = new RightTupleKey(factHandleId, sink);
                RightTuple rightTuple = context.rightTuples.get(key);
                parentLeftTuple.setBlocker(rightTuple);
                rightTuple.addBlocked(parentLeftTuple);
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(parentLeftTuple, childSink, parentLeftTuple.getPropagationContext(), true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 211: {
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                AccumulateNode.AccumulateContext accctx = new AccumulateNode.AccumulateContext();
                parentLeftTuple.setObject(accctx);
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                accctx.result = new RightTuple(handle, (RightTupleSink)((Object)sink));
                accctx.context = (Serializable[])stream.readObject();
                accctx.propagated = stream.readBoolean();
                int head = -1;
                block20: while (true) {
                    short s = stream.readShort();
                    head = s;
                    if (s == 1) break block0;
                    switch (head) {
                        case 4: {
                            int factHandleId = stream.readInt();
                            RightTupleKey key = new RightTupleKey(factHandleId, sink);
                            RightTuple rightTuple = context.rightTuples.get(key);
                            sink.createLeftTuple(parentLeftTuple, rightTuple, null, null, sink, true);
                            continue block20;
                        }
                        case 3: {
                            int sinkId = stream.readInt();
                            LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(sinkId));
                            LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, accctx.result, childSink, true);
                            InputMarshaller.readLeftTuple(childLeftTuple, context);
                            continue block20;
                        }
                    }
                    break;
                }
                throw new RuntimeDroolsException("Marshalling error. This is a bug. Please contact the development team.");
            }
            case 71: {
                ObjectHashMap memory = (ObjectHashMap)((Object)context.wm.getNodeMemory((MemoryFactory)((Object)sink)));
                int id = stream.readInt();
                long recency = stream.readLong();
                DefaultFactHandle handle = new DefaultFactHandle(id, parentLeftTuple, recency, context.wm.getEntryPoints().get(EntryPointId.DEFAULT.getEntryPointId()));
                memory.put(parentLeftTuple, handle);
                InputMarshaller.readRightTuples(handle, context);
                stream.readShort();
                break;
            }
            case 151: {
                FromNode.FromMemory memory = (FromNode.FromMemory)context.wm.getNodeMemory((MemoryFactory)((Object)sink));
                memory.betaMemory.getLeftTupleMemory().add(parentLeftTuple);
                LinkedHashMap<Object, RightTuple> matches = new LinkedHashMap<Object, RightTuple>();
                parentLeftTuple.setObject(matches);
                while (stream.readShort() == 2) {
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    InputMarshaller.readRightTuples(handle, context);
                    matches.put(handle.getObject(), handle.getFirstRightTuple());
                }
                while (stream.readShort() == 4) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    int factHandleId = stream.readInt();
                    RightTupleKey key = new RightTupleKey(factHandleId, null);
                    RightTuple rightTuple = context.rightTuples.get(key);
                    LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, rightTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 165: {
                boolean isOpen = context.readBoolean();
                if (isOpen) {
                    QueryElementNode node = (QueryElementNode)sink;
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    node.createDroolsQuery(parentLeftTuple, handle, null, null, null, null, context.wm);
                    InputMarshaller.readLeftTuples(context);
                    break;
                }
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                    context.handles.put(handle.getId(), handle);
                    RightTuple rightTuple = new RightTuple(handle);
                    LeftTupleImpl childLeftTuple = new LeftTupleImpl(parentLeftTuple, rightTuple, childSink, true);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
            case 101: {
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(pos, parentLeftTuple);
                break;
            }
            case 91: {
                boolean unificationNode = context.readBoolean();
                if (!unificationNode) break;
                InternalFactHandle handle = InputMarshaller.readFactHandle(context);
                context.handles.put(handle.getId(), handle);
                RightTuple rightTuple = new RightTuple(handle);
                parentLeftTuple.setObject(rightTuple);
                LeftTuple entry = parentLeftTuple;
                while (entry.getParent() != null) {
                    entry = entry.getParent();
                }
                DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
                LeftTuple leftTuple = ((QueryElementNode.UnificationNodeViewChangedEventListener)query.getQueryResultCollector()).getLeftTuple();
                while (stream.readShort() == 3) {
                    LeftTupleSink childSink = (LeftTupleSink)((Object)sinks.get(stream.readInt()));
                    LeftTuple childLeftTuple = childSink.createLeftTuple(leftTuple, rightTuple, childSink);
                    InputMarshaller.readLeftTuple(childLeftTuple, context);
                }
                break;
            }
        }
    }

    public static void readBehaviors(WindowNode windowNode, WindowNode.WindowMemory memory, MarshallerReaderContext inCtx) throws IOException {
        int token = -1;
        while (true) {
            short s = inCtx.readShort();
            token = s;
            if (s == 1) break;
            int i = inCtx.readInt();
            Object object = ((Object[])memory.behaviorContext)[i];
            switch (token) {
                case 100: {
                    InputMarshaller.readSlidingTimeWindowBehaviour(windowNode, memory, (SlidingTimeWindow)windowNode.getBehaviors()[i], (SlidingTimeWindow.SlidingTimeWindowContext)object, inCtx);
                    break;
                }
                case 101: {
                    InputMarshaller.readSlidingLengthWindowBehaviour(windowNode, memory, (SlidingLengthWindow)windowNode.getBehaviors()[i], (SlidingLengthWindow.SlidingLengthWindowContext)object, inCtx);
                }
            }
        }
    }

    public static void readSlidingTimeWindowBehaviour(WindowNode windowNode, WindowNode.WindowMemory memory, SlidingTimeWindow stw, SlidingTimeWindow.SlidingTimeWindowContext stwCtx, MarshallerReaderContext inCtx) throws IOException {
        if (inCtx.readBoolean()) {
            int sinkId = inCtx.readInt();
            int factId = inCtx.readInt();
            RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
            RightTupleKey key = new RightTupleKey(factId, sink);
            RightTuple rightTuple = inCtx.rightTuples.get(key);
        }
        if (inCtx.readBoolean()) {
            int size = inCtx.readInt();
            for (int i = 0; i < size; ++i) {
                int sinkId = inCtx.readInt();
                int factId = inCtx.readInt();
                RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
                RightTupleKey key = new RightTupleKey(factId, sink);
                RightTuple rightTuple = inCtx.rightTuples.get(key);
            }
        }
    }

    public static void readSlidingLengthWindowBehaviour(WindowNode windowNode, WindowNode.WindowMemory memory, SlidingLengthWindow slw, SlidingLengthWindow.SlidingLengthWindowContext slwCtx, MarshallerReaderContext inCtx) throws IOException {
        int pos = inCtx.readInt();
        int length = inCtx.readInt();
        slwCtx.pos = pos;
        for (int i = 0; i < length; ++i) {
            int factId = inCtx.readInt();
            if (factId < 0) continue;
            int sinkId = inCtx.readInt();
            RightTupleSink sink = (RightTupleSink)((Object)inCtx.sinks.get(sinkId));
            RightTupleKey key = new RightTupleKey(factId, sink);
            RightTuple rightTuple = inCtx.rightTuples.get(key);
        }
    }

    private static void addToLeftMemory(LeftTuple parentLeftTuple, BetaMemory memory) {
        memory.getLeftTupleMemory().add(parentLeftTuple);
    }

    public static void readActivations(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 8) {
            InputMarshaller.readActivation(context);
        }
    }

    public static Activation readActivation(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        long activationNumber = stream.readLong();
        int pos = stream.readInt();
        LeftTuple leftTuple = context.terminalTupleMap.get(pos);
        int salience = stream.readInt();
        String pkgName = stream.readUTF();
        String ruleName = stream.readUTF();
        Package pkg = ruleBase.getPackage(pkgName);
        Rule rule = pkg.getRule(ruleName);
        RuleTerminalNode ruleTerminalNode = (RuleTerminalNode)leftTuple.getLeftTupleSink();
        PropagationContext pc = context.propagationContexts.get(stream.readLong());
        InternalAgendaGroup agendaGroup = rule.getAgendaGroup() == null || rule.getAgendaGroup().equals("") || rule.getAgendaGroup().equals("MAIN") ? (InternalAgendaGroup)((InternalAgenda)wm.getAgenda()).getAgendaGroup("MAIN") : (InternalAgendaGroup)((InternalAgenda)wm.getAgenda()).getAgendaGroup(rule.getAgendaGroup());
        InternalRuleFlowGroup rfg = (InternalRuleFlowGroup)((InternalAgenda)wm.getAgenda()).getRuleFlowGroup(rule.getRuleFlowGroup());
        boolean scheduled = false;
        RuleTerminalNodeLeftTuple rtnLeftTuple = (RuleTerminalNodeLeftTuple)leftTuple;
        rtnLeftTuple.init(activationNumber, salience, pc, null, agendaGroup);
        AgendaItem activation = rtnLeftTuple;
        if (rule.getTimer() != null) {
            activation = new ScheduledAgendaItem(rtnLeftTuple, (InternalAgenda)wm.getAgenda());
            scheduled = true;
        }
        leftTuple.setObject(activation);
        if (stream.readBoolean()) {
            String activationGroupName = stream.readUTF();
            ((InternalAgenda)wm.getAgenda()).getActivationGroup(activationGroupName).addActivation(activation);
        }
        boolean activated = stream.readBoolean();
        activation.setQueued(activated);
        if (stream.readBoolean()) {
            InternalFactHandle handle = context.handles.get(stream.readInt());
            activation.setFactHandle(handle);
            handle.setObject(activation);
        }
        if (!scheduled && activated) {
            if (rule.getRuleFlowGroup() == null) {
                agendaGroup.add(activation);
            } else {
                rfg.add(activation);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static void readPropagationContexts(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 9) {
            InputMarshaller.readPropagationContext(context);
        }
    }

    public static void readPropagationContext(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        int type = stream.readInt();
        Rule rule = null;
        if (stream.readBoolean()) {
            String pkgName = stream.readUTF();
            String ruleName = stream.readUTF();
            Package pkg = ruleBase.getPackage(pkgName);
            rule = pkg.getRule(ruleName);
        }
        LeftTuple leftTuple = null;
        if (stream.readBoolean()) {
            int tuplePos = stream.readInt();
            leftTuple = context.terminalTupleMap.get(tuplePos);
        }
        long propagationNumber = stream.readLong();
        int factHandleId = stream.readInt();
        InternalFactHandle factHandle = context.handles.get(factHandleId);
        String entryPointId = stream.readUTF();
        EntryPointId entryPoint = context.entryPoints.get(entryPointId);
        if (entryPoint == null) {
            entryPoint = new EntryPointId(entryPointId);
            context.entryPoints.put(entryPointId, entryPoint);
        }
        PropagationContextFactory pctxFactory = context.ruleBase.getConfiguration().getComponentFactory().getPropagationContextFactory();
        PropagationContext pc = pctxFactory.createPropagationContext(propagationNumber, type, rule, leftTuple, factHandle, entryPoint);
        context.propagationContexts.put(propagationNumber, pc);
    }

    public static WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readLong());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    String strategyClassName;
                    int index = stream.readInt();
                    ObjectMarshallingStrategy strategy = null;
                    if (index >= 0) {
                        strategy = context.resolverStrategyFactory.getStrategy(index);
                        if (strategy == null) {
                            throw new IllegalStateException("No strategy of with index " + index + " available.");
                        }
                    } else if (index == -2 && (strategy = context.resolverStrategyFactory.getStrategyObject(strategyClassName = stream.readUTF())) == null) {
                        throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                    }
                    Object value = strategy.read((ObjectInputStream)stream);
                    workItem.setParameter(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        return workItem;
    }

    public static void readTimer(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        short timerType = inCtx.readShort();
        TimersInputMarshaller reader = inCtx.readersByInt.get(timerType);
        reader.read(inCtx);
    }

    public static Trigger readTrigger(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        short triggerInt = inCtx.readShort();
        switch (triggerInt) {
            case 70: {
                long startTime = inCtx.readLong();
                CronTrigger trigger = new CronTrigger();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                String expr = inCtx.readUTF();
                trigger.setCronExpression(expr);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 71: {
                IntervalTrigger trigger = new IntervalTrigger();
                long startTime = inCtx.readLong();
                trigger.setStartTime(new Date(startTime));
                if (inCtx.readBoolean()) {
                    long endTime = inCtx.readLong();
                    trigger.setEndTime(new Date(endTime));
                }
                int repeatLimit = inCtx.readInt();
                trigger.setRepeatLimit(repeatLimit);
                int repeatCount = inCtx.readInt();
                trigger.setRepeatCount(repeatCount);
                if (inCtx.readBoolean()) {
                    long nextFireTime = inCtx.readLong();
                    trigger.setNextFireTime(new Date(nextFireTime));
                }
                long period = inCtx.readLong();
                trigger.setPeriod(period);
                String[] calendarNames = (String[])inCtx.readObject();
                trigger.setCalendarNames(calendarNames);
                return trigger;
            }
            case 72: {
                long startTime = inCtx.readLong();
                PointInTimeTrigger trigger = new PointInTimeTrigger(startTime, null, null);
                return trigger;
            }
        }
        throw new RuntimeException("Unable to persist Trigger for type: " + triggerInt);
    }
}

