/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.runtime.manager.api.SchedulerProvider;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.mapper.InMemoryMapper;
import org.kie.api.KieBase;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.RegisterableItemsFactory;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.task.api.UserGroupCallback;

public class SimpleRuntimeEnvironment
implements RuntimeEnvironment,
SchedulerProvider {
    protected boolean usePersistence;
    protected EntityManagerFactory emf;
    protected Environment environment = EnvironmentFactory.newEnvironment();
    protected KieSessionConfiguration configuration;
    protected KieBase kbase;
    protected KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
    protected RegisterableItemsFactory registerableItemsFactory;
    protected Mapper mapper;
    protected UserGroupCallback userGroupCallback;
    protected GlobalSchedulerService schedulerService;
    protected ClassLoader classLoader;
    protected Properties sessionConfigProperties;

    public SimpleRuntimeEnvironment() {
        this(new SimpleRegisterableItemsFactory());
    }

    public SimpleRuntimeEnvironment(RegisterableItemsFactory registerableItemsFactory) {
        this.registerableItemsFactory = registerableItemsFactory;
    }

    public void init() {
        if (this.mapper == null) {
            this.mapper = new InMemoryMapper();
        }
    }

    public void addAsset(Resource resource, ResourceType type) {
        this.kbuilder.add(resource, type);
        if (this.kbuilder.hasErrors()) {
            StringBuffer errorMessage = new StringBuffer();
            for (KnowledgeBuilderError error : this.kbuilder.getErrors()) {
                errorMessage.append(error.getMessage() + ",");
            }
            this.kbuilder.undo();
            throw new IllegalArgumentException("Cannot add asset: " + errorMessage.toString());
        }
    }

    public void addToEnvironment(String name, Object value) {
        this.environment.set(name, value);
    }

    public void addToConfiguration(String name, String value) {
        if (this.sessionConfigProperties == null) {
            this.sessionConfigProperties = new Properties();
        }
        this.sessionConfigProperties.setProperty(name, value);
    }

    public KieBase getKieBase() {
        if (this.kbase == null) {
            this.kbase = this.kbuilder.newKnowledgeBase();
        }
        return this.kbase;
    }

    public Environment getEnvironment() {
        return this.copyEnvironment();
    }

    public KieSessionConfiguration getConfiguration() {
        if (this.sessionConfigProperties != null) {
            return KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)this.sessionConfigProperties);
        }
        return null;
    }

    public boolean usePersistence() {
        return this.usePersistence;
    }

    public RegisterableItemsFactory getRegisterableItemsFactory() {
        return this.registerableItemsFactory;
    }

    public void close() {
    }

    protected void addIfPresent(String name, Environment copy) {
        Object value = this.environment.get(name);
        if (value != null) {
            copy.set(name, value);
        }
    }

    protected Environment copyEnvironment() {
        Environment copy = EnvironmentFactory.newEnvironment();
        this.addIfPresent("org.kie.api.persistence.jpa.EntityManagerFactory", copy);
        this.addIfPresent("org.kie.api.time.Calendars", copy);
        this.addIfPresent("org.kie.build.DateFormats", copy);
        this.addIfPresent("org.kie.Globals", copy);
        this.addIfPresent("org.kie.api.marshalling.ObjectMarshallingStrategies", copy);
        this.addIfPresent("org.kie.api.persistence.PersistenceContextManager", copy);
        this.addIfPresent("org.kie.transaction.TransactionManager", copy);
        this.addIfPresent("org.kie.transaction.TransactionSynchronizationRegistry", copy);
        this.addIfPresent("org.kie.transaction.Transaction", copy);
        return copy;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public UserGroupCallback getUserGroupCallback() {
        return this.userGroupCallback;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public Properties getSessionConfigProperties() {
        return this.sessionConfigProperties;
    }

    public void setSessionConfigProperties(Properties sessionConfigProperties) {
        this.sessionConfigProperties = sessionConfigProperties;
    }

    public void setUsePersistence(boolean usePersistence) {
        this.usePersistence = usePersistence;
    }

    public void setKieBase(KieBase kbase) {
        this.kbase = kbase;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public GlobalSchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    public void setSchedulerService(GlobalSchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setRegisterableItemsFactory(RegisterableItemsFactory registerableItemsFactory) {
        this.registerableItemsFactory = registerableItemsFactory;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

