/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;

public class InMemorySessionFactory
implements SessionFactory {
    private RuntimeEnvironment environment;
    private KieBase kbase;
    private Map<Integer, KieSession> sessions = new ConcurrentHashMap<Integer, KieSession>();

    public InMemorySessionFactory(RuntimeEnvironment environment) {
        this.environment = environment;
        this.kbase = environment.getKieBase();
    }

    public KieSession newKieSession() {
        KieSession ksession = this.kbase.newKieSession(this.environment.getConfiguration(), this.environment.getEnvironment());
        this.sessions.put(ksession.getId(), ksession);
        return ksession;
    }

    public KieSession findKieSessionById(Integer sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            return this.sessions.get(sessionId);
        }
        throw new SessionNotFoundException("Session with id " + sessionId + " was not found");
    }

    public void close() {
        this.sessions.clear();
    }
}

