/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.wih.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.services.task.impl.model.DeadlineImpl;
import org.jbpm.services.task.impl.model.DeadlinesImpl;
import org.jbpm.services.task.impl.model.EmailNotificationHeaderImpl;
import org.jbpm.services.task.impl.model.EmailNotificationImpl;
import org.jbpm.services.task.impl.model.EscalationImpl;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.LanguageImpl;
import org.jbpm.services.task.impl.model.ReassignmentImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.task.api.model.Deadline;
import org.kie.internal.task.api.model.Deadlines;
import org.kie.internal.task.api.model.Notification;
import org.kie.internal.task.api.model.Reassignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskHandlerHelper {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskHandlerHelper.class);
    private static final String COMPONENT_SEPARATOR = "\\^";
    private static final String ELEMENT_SEPARATOR = "@";
    private static final String ATTRIBUTES_SEPARATOR = "\\|";
    private static final String ATTRIBUTES_ELEMENTS_SEPARATOR = ",";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String[] KNOWN_KEYS = new String[]{"users", "groups", "from", "tousers", "togroups", "replyto", "subject", "body"};

    public static Deadlines setDeadlines(WorkItem workItem, List<OrganizationalEntity> businessAdministrators, Environment environment) {
        String notStartedReassign = (String)workItem.getParameter("NotStartedReassign");
        String notStartedNotify = (String)workItem.getParameter("NotStartedNotify");
        String notCompletedReassign = (String)workItem.getParameter("NotCompletedReassign");
        String notCompletedNotify = (String)workItem.getParameter("NotCompletedNotify");
        DeadlinesImpl deadlinesTotal = new DeadlinesImpl();
        ArrayList<Deadline> startDeadlines = new ArrayList<Deadline>();
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedNotify, businessAdministrators, environment));
        startDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notStartedReassign, businessAdministrators, environment));
        ArrayList<Deadline> endDeadlines = new ArrayList<Deadline>();
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedNotify, businessAdministrators, environment));
        endDeadlines.addAll(HumanTaskHandlerHelper.parseDeadlineString(notCompletedReassign, businessAdministrators, environment));
        if (!startDeadlines.isEmpty()) {
            deadlinesTotal.setStartDeadlines(startDeadlines);
        }
        if (!endDeadlines.isEmpty()) {
            deadlinesTotal.setEndDeadlines(endDeadlines);
        }
        return deadlinesTotal;
    }

    protected static List<Deadline> parseDeadlineString(String deadlineInfo, List<OrganizationalEntity> businessAdministrators, Environment environment) {
        if (deadlineInfo == null || deadlineInfo.length() == 0) {
            return new ArrayList<Deadline>();
        }
        ArrayList<Deadline> deadlines = new ArrayList<Deadline>();
        String[] allComponents = deadlineInfo.split(COMPONENT_SEPARATOR);
        BusinessCalendar businessCalendar = null;
        if (environment != null && environment.get("jbpm.business.calendar") != null) {
            businessCalendar = (BusinessCalendar)environment.get("jbpm.business.calendar");
        }
        for (String component : allComponents) {
            String[] mainComponents = component.split(ELEMENT_SEPARATOR);
            if (mainComponents != null && mainComponents.length == 2) {
                String actionComponent = mainComponents[0].substring(1, mainComponents[0].length() - 1);
                String expireComponents = mainComponents[1].substring(1, mainComponents[1].length() - 1);
                String[] expireElements = expireComponents.split(ATTRIBUTES_ELEMENTS_SEPARATOR);
                DeadlineImpl taskDeadline = null;
                for (String expiresAt : expireElements) {
                    taskDeadline = new DeadlineImpl();
                    if (businessCalendar != null) {
                        taskDeadline.setDate(businessCalendar.calculateBusinessTimeAsDate(expiresAt));
                    } else {
                        taskDeadline.setDate(new Date(System.currentTimeMillis() + TimeUtils.parseTimeString((String)expiresAt)));
                    }
                    ArrayList<EscalationImpl> escalations = new ArrayList<EscalationImpl>();
                    EscalationImpl escalation = new EscalationImpl();
                    escalations.add(escalation);
                    escalation.setName("Default escalation");
                    taskDeadline.setEscalations(escalations);
                    escalation.setReassignments(HumanTaskHandlerHelper.parseReassignment(actionComponent));
                    escalation.setNotifications(HumanTaskHandlerHelper.parseNotifications(actionComponent, businessAdministrators));
                    deadlines.add((Deadline)taskDeadline);
                }
                continue;
            }
            logger.warn("Incorrect syntax of deadline property {}", (Object)deadlineInfo);
        }
        return deadlines;
    }

    protected static List<Notification> parseNotifications(String notificationString, List<OrganizationalEntity> businessAdministrators) {
        ArrayList<Notification> notifications = new ArrayList<Notification>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(notificationString);
        if (parameters.containsKey("tousers") || parameters.containsKey("togroups")) {
            String groupRecipients;
            String locale = parameters.get("locale");
            if (locale == null) {
                locale = "en-UK";
            }
            EmailNotificationImpl emailNotification = new EmailNotificationImpl();
            notifications.add((Notification)emailNotification);
            emailNotification.setBusinessAdministrators(businessAdministrators);
            HashMap<LanguageImpl, EmailNotificationHeaderImpl> emailHeaders = new HashMap<LanguageImpl, EmailNotificationHeaderImpl>();
            ArrayList<I18NTextImpl> subjects = new ArrayList<I18NTextImpl>();
            ArrayList<I18NTextImpl> names = new ArrayList<I18NTextImpl>();
            ArrayList<Object> notificationRecipients = new ArrayList<Object>();
            EmailNotificationHeaderImpl emailHeader = new EmailNotificationHeaderImpl();
            emailHeader.setBody(parameters.get("body"));
            emailHeader.setFrom(parameters.get("from"));
            emailHeader.setReplyTo(parameters.get("replyto"));
            emailHeader.setLanguage(locale);
            emailHeader.setSubject(parameters.get("subject"));
            emailHeaders.put(new LanguageImpl(locale), emailHeader);
            subjects.add(new I18NTextImpl(locale, emailHeader.getSubject()));
            names.add(new I18NTextImpl(locale, emailHeader.getSubject()));
            String recipients = parameters.get("tousers");
            if (recipients != null && recipients.trim().length() > 0) {
                String[] recipientsIds;
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    notificationRecipients.add(new UserImpl(id.trim()));
                }
            }
            if ((groupRecipients = parameters.get("togroups")) != null && groupRecipients.trim().length() > 0) {
                String[] groupRecipientsIds;
                for (String id : groupRecipientsIds = groupRecipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    notificationRecipients.add(new GroupImpl(id.trim()));
                }
            }
            emailNotification.setEmailHeaders(emailHeaders);
            emailNotification.setNames(names);
            emailNotification.setRecipients(notificationRecipients);
            emailNotification.setSubjects(subjects);
        }
        return notifications;
    }

    protected static List<Reassignment> parseReassignment(String reassignString) {
        ArrayList<Reassignment> reassignments = new ArrayList<Reassignment>();
        Map<String, String> parameters = HumanTaskHandlerHelper.asMap(reassignString);
        if (parameters.containsKey("users") || parameters.containsKey("groups")) {
            String[] recipientsIds;
            ReassignmentImpl reassignment = new ReassignmentImpl();
            ArrayList<Object> reassignmentUsers = new ArrayList<Object>();
            String recipients = parameters.get("users");
            if (recipients != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    reassignmentUsers.add(new UserImpl(id.trim()));
                }
            }
            if ((recipients = parameters.get("groups")) != null && recipients.trim().length() > 0) {
                for (String id : recipientsIds = recipients.split(ATTRIBUTES_ELEMENTS_SEPARATOR)) {
                    reassignmentUsers.add(new GroupImpl(id.trim()));
                }
            }
            reassignment.setPotentialOwners(reassignmentUsers);
            reassignments.add((Reassignment)reassignment);
        }
        return reassignments;
    }

    protected static Map<String, String> asMap(String parsableString) {
        String[] actionElements = parsableString.split(ATTRIBUTES_SEPARATOR);
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String actionElem : actionElements) {
            for (String knownKey : KNOWN_KEYS) {
                if (!actionElem.startsWith(knownKey)) continue;
                try {
                    parameters.put(knownKey, actionElem.substring(knownKey.length() + KEY_VALUE_SEPARATOR.length()));
                }
                catch (IndexOutOfBoundsException e) {
                    parameters.put(knownKey, "");
                }
            }
        }
        return parameters;
    }
}

