/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class ThrowExceptionProcessor
extends ServiceSupport
implements Processor,
Traceable {
    private final Exception exception;

    public ThrowExceptionProcessor(Exception exception) {
        ObjectHelper.notNull(exception, "exception", this);
        this.exception = exception;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        exchange.setException(this.exception);
    }

    @Override
    public String getTraceLabel() {
        return "throwException[" + this.exception.getClass().getSimpleName() + "]";
    }

    public String toString() {
        return "ThrowException";
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

