/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringUtils {
    public static String convertStringToCharEntities(String str) {
        DecimalFormat df = new DecimalFormat("000");
        StringBuffer buf = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            buf.append("&#");
            buf.append(df.format(chars[i]));
            buf.append(';');
        }
        return buf.toString();
    }

    public static String getTextAsFormattedLines(String text, int lineLength) {
        StringBuffer retdata = new StringBuffer();
        ArrayList<String> lines = new ArrayList<String>();
        String t = new String(text);
        while (t.length() > lineLength) {
            String s = t.substring(0, lineLength);
            String rest = t.substring(lineLength);
            int lastInd = s.lastIndexOf(32);
            if (lastInd == lineLength) {
                retdata.append(s);
                retdata.append('\n');
            } else {
                if (rest.charAt(0) != ' ') {
                    int indexOfFirst = rest.indexOf(32);
                    String halfWord = rest.substring(0, indexOfFirst);
                    s = s + halfWord;
                    retdata.append(s);
                    retdata.append('\n');
                    rest = rest.substring(indexOfFirst + 1);
                }
                rest = rest.trim();
            }
            t = rest;
        }
        lines.add(t.trim());
        retdata.append(t.trim());
        retdata.append('\n');
        return retdata.toString();
    }

    public static boolean hasCharInRange(String value, char start, char end) {
        if (value == null) {
            return false;
        }
        char[] chars = value.toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < start || chars[i] > end) continue;
            found = true;
        }
        return found;
    }

    public static List tokenizeString(String str, String token) {
        ArrayList<String> retData = new ArrayList<String>();
        String s = new String(str);
        int start = s.indexOf(token);
        if (start > -1) {
            while (start > -1) {
                String tok = s.substring(0, start);
                int end = start + token.length();
                s = s.substring(end);
                if (!tok.equals("")) {
                    retData.add(tok);
                }
                start = s.indexOf(token);
            }
            if (!s.equals("")) {
                retData.add(s);
            }
        } else {
            retData.add(s);
        }
        return retData;
    }

    public static boolean hasValue(String v) {
        if (v == null) {
            return false;
        }
        return !v.equals("");
    }

    public static String replaceAllStrings(String text, Map map, boolean caseSensitive) {
        String newText = new String(text);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            String t = k.toString();
            String v = (String)map.get(k);
            newText = StringUtils.replaceString(newText, t, v, caseSensitive);
        }
        return newText;
    }

    public static String replaceAllStrings(String text, Map map) {
        String newText = text;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object k = iter.next();
            String t = (String)k;
            String v = (String)map.get(k);
            newText = StringUtils.replaceString(newText, t, v);
        }
        return newText;
    }

    public static String replaceString(String text, String str, String replace, boolean caseSensitive) throws NullPointerException {
        if (text == null) {
            throw new NullPointerException("text parm.");
        }
        if (str == null) {
            throw new NullPointerException("str parm.");
        }
        if (replace == null) {
            throw new NullPointerException("replace parm.");
        }
        StringBuffer buf = new StringBuffer(text);
        String newText = new String(text);
        String s = new String(str);
        if (!caseSensitive) {
            s = s.toLowerCase();
            newText = newText.toLowerCase();
        }
        int index = newText.indexOf(s);
        while (index != -1) {
            buf.replace(index, index + s.length(), replace);
            newText = buf.toString();
            if (!caseSensitive) {
                newText = newText.toLowerCase();
            }
            index = newText.indexOf(s, index + replace.length());
        }
        return buf.toString();
    }

    public static String replaceString(String text, String str, String replace) throws NullPointerException {
        if (text == null) {
            throw new NullPointerException("text parm (arg 1).");
        }
        if (str == null) {
            throw new NullPointerException("str parm (arg 2).");
        }
        if (replace == null) {
            throw new NullPointerException("replace parm (arg3).");
        }
        StringBuffer buf = new StringBuffer(text);
        int index = buf.indexOf(str);
        while (index != -1) {
            buf.replace(index, index + str.length(), replace);
            index = buf.indexOf(str, index + replace.length());
        }
        return buf.toString();
    }

    public static boolean areAllCharsInRange(String value, char start, char end) {
        if (start > end) {
            return false;
        }
        if (value == null) {
            return false;
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= start && chars[i] <= end) continue;
            return false;
        }
        return true;
    }

    public static String removeChar(String str, char c) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == c) continue;
            buf.append(chars[i]);
        }
        return buf.toString();
    }
}

