/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.drools.core.FactException;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.ShadowProxy;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Activation;

public class ClassObjectTypeConf
implements ObjectTypeConf,
Externalizable {
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    private static final long serialVersionUID = 510L;
    private Class<?> cls;
    private transient InternalRuleBase ruleBase;
    private ObjectTypeNode[] objectTypeNodes;
    protected boolean shadowEnabled;
    private ObjectTypeNode concreteObjectTypeNode;
    private EntryPointId entryPoint;
    private TypeDeclaration typeDecl;
    private boolean tmsEnabled;
    private boolean supportsPropertyListeners;
    private boolean isEvent;
    private static final ObjectTypeNodeComparator OBJECT_TYPE_NODE_COMPARATOR = new ObjectTypeNodeComparator();

    public ClassObjectTypeConf() {
    }

    public ClassObjectTypeConf(EntryPointId entryPoint, Class<?> clazz, InternalRuleBase ruleBase) {
        this.cls = Activation.class.isAssignableFrom(clazz) ? ClassObjectType.Match_ObjectType.getClassType() : clazz;
        this.ruleBase = ruleBase;
        this.entryPoint = entryPoint;
        this.typeDecl = ruleBase.getTypeDeclaration(clazz);
        this.isEvent = this.typeDecl != null && this.typeDecl.getRole() == TypeDeclaration.Role.EVENT;
        ClassObjectType objectType = ((ReteooRuleBase)ruleBase).getClassFieldAccessorCache().getClassObjectType(new ClassObjectType(clazz, this.isEvent));
        this.concreteObjectTypeNode = ruleBase.getRete().getObjectTypeNodes(entryPoint).get(objectType);
        if (this.concreteObjectTypeNode == null) {
            BuildContext context = new BuildContext(ruleBase, ruleBase.getRete().getRuleBase().getReteooBuilder().getIdGenerator());
            context.setCurrentEntryPoint(entryPoint);
            if (DroolsQuery.class == clazz) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else if (context.getRuleBase().getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            this.concreteObjectTypeNode = PatternBuilder.attachObjectTypeNode(context, objectType);
        }
        this.defineShadowProxyData(clazz);
        this.supportsPropertyListeners = this.checkPropertyListenerSupport(clazz);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.ruleBase = (InternalRuleBase)stream.readObject();
        this.cls = (Class)stream.readObject();
        this.objectTypeNodes = (ObjectTypeNode[])stream.readObject();
        this.shadowEnabled = stream.readBoolean();
        this.concreteObjectTypeNode = (ObjectTypeNode)stream.readObject();
        this.entryPoint = (EntryPointId)stream.readObject();
        this.tmsEnabled = stream.readBoolean();
        this.supportsPropertyListeners = stream.readBoolean();
        this.isEvent = stream.readBoolean();
        this.defineShadowProxyData(this.cls);
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.ruleBase);
        stream.writeObject(this.cls);
        stream.writeObject(this.objectTypeNodes);
        stream.writeBoolean(this.shadowEnabled);
        stream.writeObject(this.concreteObjectTypeNode);
        stream.writeObject(this.entryPoint);
        stream.writeBoolean(this.tmsEnabled);
        stream.writeBoolean(this.supportsPropertyListeners);
        stream.writeBoolean(this.isEvent);
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.cls.isAssignableFrom((Class)object);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        return this.concreteObjectTypeNode;
    }

    private void defineShadowProxyData(Class<?> clazz) {
        if (ShadowProxy.class.isAssignableFrom(this.cls)) {
            this.shadowEnabled = true;
        }
    }

    private boolean checkPropertyListenerSupport(Class<?> clazz) {
        Method method = null;
        try {
            method = clazz.getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method != null;
    }

    public static String getPackageName(Class<?> clazz, Package pkg) {
        String pkgName = "";
        if (pkg == null) {
            int index = clazz.getName().lastIndexOf(46);
            if (index != -1) {
                pkgName = clazz.getName().substring(0, index);
            }
        } else {
            pkgName = pkg.getName();
        }
        return pkgName;
    }

    @Override
    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    @Override
    public void resetCache() {
        this.objectTypeNodes = null;
        this.defineShadowProxyData(this.cls);
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.objectTypeNodes == null) {
            this.objectTypeNodes = this.getMatchingObjectTypes(this.cls);
        }
        return this.objectTypeNodes;
    }

    private ObjectTypeNode[] getMatchingObjectTypes(Class<?> clazz) throws FactException {
        ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
        for (ObjectTypeNode node : this.ruleBase.getRete().getObjectTypeNodes(this.entryPoint).values()) {
            if (clazz == DroolsQuery.class) {
                if (((ClassObjectType)node.getObjectType()).getClassType() != clazz) continue;
                cache.add(node);
                continue;
            }
            if (!node.isAssignableFrom(new ClassObjectType(clazz))) continue;
            cache.add(node);
        }
        Collections.sort(cache, OBJECT_TYPE_NODE_COMPARATOR);
        return cache.toArray(new ObjectTypeNode[cache.size()]);
    }

    @Override
    public boolean isActive() {
        return this.getConcreteObjectTypeNode().getSinkPropagator().getSinks().length > 0;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    @Override
    public boolean isTrait() {
        return this.typeDecl != null && (this.typeDecl.getKind() == TypeDeclaration.Kind.TRAIT || this.typeDecl.getTypeClassDef().isTraitable()) || Thing.class.isAssignableFrom(this.cls) || TraitableBean.class.isAssignableFrom(this.cls);
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return this.typeDecl;
    }

    @Override
    public boolean isDynamic() {
        return this.typeDecl != null && this.typeDecl.isDynamic();
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public boolean isSupportsPropertyChangeListeners() {
        return this.supportsPropertyListeners;
    }

    private static final class ObjectTypeNodeComparator
    implements Comparator<ObjectTypeNode> {
        private ObjectTypeNodeComparator() {
        }

        @Override
        public int compare(ObjectTypeNode o1, ObjectTypeNode o2) {
            return o1.getId() - o2.getId();
        }
    }
}

